/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.observation;

import io.smallrye.reactive.messaging.observation.MessageObservation;
import java.time.Duration;
import org.eclipse.microprofile.reactive.messaging.Message;

public class DefaultMessageObservation
implements MessageObservation {
    private final String channelName;
    private final long creation;
    protected volatile long completion;
    protected volatile boolean done;
    protected volatile Throwable nackReason;

    public DefaultMessageObservation(String channelName) {
        this(channelName, System.nanoTime());
    }

    public DefaultMessageObservation(String channelName, long creationTime) {
        this.channelName = channelName;
        this.creation = creationTime;
    }

    @Override
    public String getChannel() {
        return this.channelName;
    }

    @Override
    public long getCreationTime() {
        return this.creation;
    }

    @Override
    public long getCompletionTime() {
        return this.completion;
    }

    @Override
    public boolean isDone() {
        return this.done || this.nackReason != null;
    }

    @Override
    public Throwable getReason() {
        return this.nackReason;
    }

    @Override
    public Duration getCompletionDuration() {
        if (this.isDone()) {
            return Duration.ofNanos(this.completion - this.creation);
        }
        return null;
    }

    @Override
    public void onMessageAck(Message<?> message) {
        this.completion = System.nanoTime();
        this.done = true;
    }

    @Override
    public void onMessageNack(Message<?> message, Throwable reason) {
        this.completion = System.nanoTime();
        this.nackReason = reason;
    }
}

