/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.annotated.slim;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.manager.BeanManagerImpl;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class AnnotatedTypeIdentifierMarshaller
implements ProtoStreamMarshaller<AnnotatedTypeIdentifier> {
    private static final int BEAN_MANAGER_INDEX = 1;
    private static final int CLASS_NAME_INDEX = 2;
    private static final int MODIFIED_CLASS_NAME_INDEX = 3;
    private static final int SUFFIX_INDEX = 4;

    public Class<? extends AnnotatedTypeIdentifier> getJavaClass() {
        return AnnotatedTypeIdentifier.class;
    }

    public AnnotatedTypeIdentifier readFrom(ProtoStreamReader reader) throws IOException {
        BeanManagerImpl manager = null;
        String className = null;
        boolean modified = false;
        String suffix = null;
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    manager = (BeanManagerImpl)reader.readAny(BeanManagerImpl.class);
                    continue block6;
                }
                case 3: {
                    modified = true;
                }
                case 2: {
                    className = (String)reader.readAny(String.class);
                    continue block6;
                }
                case 4: {
                    suffix = (String)reader.readAny(String.class);
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        return AnnotatedTypeIdentifier.of((String)manager.getContextId(), (String)manager.getId(), className, suffix, (boolean)modified);
    }

    public void writeTo(ProtoStreamWriter writer, AnnotatedTypeIdentifier identifier) throws IOException {
        BeanManagerImpl manager = Container.instance((String)identifier.getContextId()).getBeanManager(identifier.getBdaId());
        if (manager != null) {
            writer.writeAny(1, (Object)manager);
        }
        writer.writeAny(identifier.isModified() ? 3 : 2, (Object)identifier.getClassName());
        String suffix = identifier.getSuffix();
        if (suffix != null) {
            writer.writeAny(4, (Object)suffix);
        }
    }
}

