/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.function.Function;
import org.jboss.msc.service.management.ServiceStatus;

final class Functions {
    private Functions() {
    }

    static final class ServiceIdModeFunction
    implements Function<ServiceStatus, String> {
        private final String expectedValue;

        ServiceIdModeFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public String apply(ServiceStatus serviceStatus) {
            return serviceStatus.getMode().equals(this.expectedValue) ? serviceStatus.getId() : null;
        }
    }

    static final class ServiceModeFunction
    implements Function<ServiceStatus, ServiceStatus> {
        private final String expectedValue;

        ServiceModeFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public ServiceStatus apply(ServiceStatus serviceStatus) {
            return serviceStatus.getMode().equals(this.expectedValue) ? serviceStatus : null;
        }
    }

    static final class ServiceIdStateFunction
    implements Function<ServiceStatus, String> {
        private final String expectedValue;

        ServiceIdStateFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public String apply(ServiceStatus serviceStatus) {
            return serviceStatus.getState().equals(this.expectedValue) ? serviceStatus.getId() : null;
        }
    }

    static final class ServiceStateFunction
    implements Function<ServiceStatus, ServiceStatus> {
        private final String expectedValue;

        ServiceStateFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public ServiceStatus apply(ServiceStatus serviceStatus) {
            return serviceStatus.getState().equals(this.expectedValue) ? serviceStatus : null;
        }
    }

    static final class ServiceIdFunction
    implements Function<ServiceStatus, ServiceStatus> {
        private final String expectedValue;

        ServiceIdFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public ServiceStatus apply(ServiceStatus serviceStatus) {
            return serviceStatus.getId().equals(this.expectedValue) ? serviceStatus : null;
        }
    }

    static final class ServiceIdMissingValueFunction
    implements Function<ServiceStatus, String> {
        private final String expectedValue;

        ServiceIdMissingValueFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public String apply(ServiceStatus serviceStatus) {
            for (String missingValue : serviceStatus.getMissingValues()) {
                if (!missingValue.equals(this.expectedValue)) continue;
                return serviceStatus.getId();
            }
            return null;
        }
    }

    static final class ServiceMissingValueFunction
    implements Function<ServiceStatus, ServiceStatus> {
        private final String expectedValue;

        ServiceMissingValueFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public ServiceStatus apply(ServiceStatus serviceStatus) {
            for (String missingValue : serviceStatus.getMissingValues()) {
                if (!missingValue.equals(this.expectedValue)) continue;
                return serviceStatus;
            }
            return null;
        }
    }

    static final class ServiceIdProvidingValueFunction
    implements Function<ServiceStatus, String> {
        private final String expectedValue;

        ServiceIdProvidingValueFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public String apply(ServiceStatus serviceStatus) {
            for (String providedValue : serviceStatus.getProvidedValues()) {
                if (!providedValue.equals(this.expectedValue)) continue;
                return serviceStatus.getId();
            }
            return null;
        }
    }

    static final class ServiceProvidingValueFunction
    implements Function<ServiceStatus, ServiceStatus> {
        private final String expectedValue;

        ServiceProvidingValueFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public ServiceStatus apply(ServiceStatus serviceStatus) {
            for (String providedValue : serviceStatus.getProvidedValues()) {
                if (!providedValue.equals(this.expectedValue)) continue;
                return serviceStatus;
            }
            return null;
        }
    }

    static final class ServiceIdRequiringValueFunction
    implements Function<ServiceStatus, String> {
        private final String expectedValue;

        ServiceIdRequiringValueFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public String apply(ServiceStatus serviceStatus) {
            for (String requiredValue : serviceStatus.getRequiredValues()) {
                if (!requiredValue.equals(this.expectedValue)) continue;
                return serviceStatus.getId();
            }
            return null;
        }
    }

    static final class ServiceRequiringValueFunction
    implements Function<ServiceStatus, ServiceStatus> {
        private final String expectedValue;

        ServiceRequiringValueFunction(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public ServiceStatus apply(ServiceStatus serviceStatus) {
            for (String requiredValue : serviceStatus.getRequiredValues()) {
                if (!requiredValue.equals(this.expectedValue)) continue;
                return serviceStatus;
            }
            return null;
        }
    }

    static final class ServiceIdIdentityFunction
    implements Function<ServiceStatus, String> {
        static final Function<ServiceStatus, String> INSTANCE = new ServiceIdIdentityFunction();

        ServiceIdIdentityFunction() {
        }

        @Override
        public String apply(ServiceStatus serviceStatus) {
            return serviceStatus.getId();
        }
    }

    static final class ServiceIdentityFunction
    implements Function<ServiceStatus, ServiceStatus> {
        static final Function<ServiceStatus, ServiceStatus> INSTANCE = new ServiceIdentityFunction();

        ServiceIdentityFunction() {
        }

        @Override
        public ServiceStatus apply(ServiceStatus serviceStatus) {
            return serviceStatus;
        }
    }
}

