/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.util.ArrayList;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.micrometer.MicrometerSubsystemModel;
import org.wildfly.extension.micrometer.otlp.OtlpRegistryDefinitionRegistrar;
import org.wildfly.extension.micrometer.prometheus.PrometheusRegistryDefinitionRegistrar;

public class MicrometerExtensionTransformerRegistration
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "micrometer";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ModelVersion currentModel = registration.getCurrentSubsystemVersion();
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)currentModel);
        this.from2(chainedBuilder.createBuilder(currentModel, MicrometerSubsystemModel.VERSION_1_1_0.getVersion()));
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{MicrometerSubsystemModel.VERSION_1_1_0.getVersion()}});
    }

    private void from2(ResourceTransformationDescriptionBuilder builder) {
        builder.rejectChildResource(PrometheusRegistryDefinitionRegistrar.PATH);
        ResourceTransformationDescriptionBuilder otlp = builder.addChildResource(OtlpRegistryDefinitionRegistrar.PATH);
        otlp.addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)OtlpOperationTransformer.INSTANCE);
        otlp.addOperationTransformationOverride("remove").setCustomOperationTransformer((OperationTransformer)OtlpOperationTransformer.INSTANCE);
        otlp.addOperationTransformationOverride("write-attribute").setCustomOperationTransformer((OperationTransformer)OtlpOperationTransformer.INSTANCE);
        otlp.addOperationTransformationOverride("undefine-attribute").setCustomOperationTransformer((OperationTransformer)OtlpOperationTransformer.INSTANCE);
        builder.setCustomResourceTransformer(new ResourceTransformer(){

            public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) {
                if (resource.hasChild(OtlpRegistryDefinitionRegistrar.PATH)) {
                    Resource otlp = resource.removeChild(OtlpRegistryDefinitionRegistrar.PATH);
                    resource.getModel().get(OtlpRegistryDefinitionRegistrar.STEP.getName()).set(otlp.getModel().get(OtlpRegistryDefinitionRegistrar.STEP.getName()));
                    resource.getModel().get(OtlpRegistryDefinitionRegistrar.ENDPOINT.getName()).set(otlp.getModel().get(OtlpRegistryDefinitionRegistrar.ENDPOINT.getName()));
                }
                context.addTransformedResourceFromRoot(address, resource);
            }
        });
    }

    private static class OtlpOperationTransformer
    implements OperationTransformer {
        static final OtlpOperationTransformer INSTANCE = new OtlpOperationTransformer();

        private OtlpOperationTransformer() {
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) {
            String name = operation.get("operation").asString();
            ArrayList<ModelNode> operations = new ArrayList<ModelNode>();
            if (name.equals("add") || name.equals("remove")) {
                String endpoint;
                Long step = operation.hasDefined(OtlpRegistryDefinitionRegistrar.STEP.getName()) ? Long.valueOf(operation.get(OtlpRegistryDefinitionRegistrar.STEP.getName()).resolve().asLong()) : null;
                String string = endpoint = operation.hasDefined(OtlpRegistryDefinitionRegistrar.ENDPOINT.getName()) ? operation.get(OtlpRegistryDefinitionRegistrar.ENDPOINT.getName()).resolve().asString() : null;
                if (step == null) {
                    operations.add(Util.getUndefineAttributeOperation((PathAddress)address.getParent(), (String)OtlpRegistryDefinitionRegistrar.STEP.getName()));
                } else {
                    operations.add(Util.getWriteAttributeOperation((PathAddress)address.getParent(), (String)OtlpRegistryDefinitionRegistrar.STEP.getName(), (ModelNode)new ModelNode(step.longValue())));
                }
                if (endpoint == null) {
                    operations.add(Util.getUndefineAttributeOperation((PathAddress)address.getParent(), (String)OtlpRegistryDefinitionRegistrar.ENDPOINT.getName()));
                } else {
                    operations.add(Util.getWriteAttributeOperation((PathAddress)address.getParent(), (String)OtlpRegistryDefinitionRegistrar.ENDPOINT.getName(), (ModelNode)new ModelNode(endpoint)));
                }
            } else if (name.equals("write-attribute") || name.equals("undefine-attribute")) {
                PathAddress addr = PathAddress.pathAddress((ModelNode)operation.get("address"));
                ModelNode replaced = operation.clone();
                operation.get("address").set(addr.getParent().toModelNode());
                operations.add(replaced);
            }
            ModelNode transformed = operations.size() == 1 ? (ModelNode)operations.get(0) : Util.createCompositeOperation(operations);
            return new OperationTransformer.TransformedOperation(transformed, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }
}

