/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.injection.deployment;

import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSPasswordCredential;
import jakarta.jms.JMSSessionMode;
import org.jboss.metadata.property.PropertyReplacer;
import org.wildfly.extension.messaging.activemq.injection.deployment.JMSCDIExtension;

class JMSInfo {
    private final String connectionFactoryLookup;
    private final String userName;
    private final String password;
    private final int sessionMode;

    JMSInfo(JMSConnectionFactory connectionFactory, JMSPasswordCredential credential, JMSSessionMode sessionMode) {
        PropertyReplacer propertyReplacer = JMSCDIExtension.propertyReplacer;
        this.connectionFactoryLookup = connectionFactory != null ? propertyReplacer.replaceProperties(connectionFactory.value()) : "java:comp/DefaultJMSConnectionFactory";
        if (credential != null) {
            this.userName = propertyReplacer.replaceProperties(credential.userName());
            this.password = propertyReplacer.replaceProperties(credential.password());
        } else {
            this.userName = null;
            this.password = null;
        }
        this.sessionMode = sessionMode != null ? sessionMode.value() : 1;
    }

    String getConnectionFactoryLookup() {
        return this.connectionFactoryLookup;
    }

    String getUserName() {
        return this.userName;
    }

    String getPassword() {
        return this.password;
    }

    int getSessionMode() {
        return this.sessionMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JMSInfo jmsInfo = (JMSInfo)o;
        if (this.sessionMode != jmsInfo.sessionMode) {
            return false;
        }
        if (this.connectionFactoryLookup != null ? !this.connectionFactoryLookup.equals(jmsInfo.connectionFactoryLookup) : jmsInfo.connectionFactoryLookup != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(jmsInfo.password) : jmsInfo.password != null) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(jmsInfo.userName) : jmsInfo.userName != null);
    }

    public int hashCode() {
        int result = this.connectionFactoryLookup != null ? this.connectionFactoryLookup.hashCode() : 0;
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + this.sessionMode;
        return result;
    }
}

