/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.PropertyReadAction;

final class ModularContentHandlerFactory
implements ContentHandlerFactory {
    private static final PrivilegedAction<String> CONTENT_MODULES_LIST_ACTION = new PropertyReadAction("jboss.content.handler.modules");
    private static final List<Module> modules;
    static final ModularContentHandlerFactory INSTANCE;

    ModularContentHandlerFactory() {
    }

    static void addHandlerModule(Module module) {
        modules.add(module);
    }

    @Override
    public ContentHandler createContentHandler(String mimeType) {
        for (Module module : modules) {
            ServiceLoader<ContentHandlerFactory> loader = module.loadService(ContentHandlerFactory.class);
            for (ContentHandlerFactory factory : loader) {
                try {
                    ContentHandler handler = factory.createContentHandler(mimeType);
                    if (handler == null) continue;
                    return handler;
                }
                catch (RuntimeException runtimeException) {
                }
            }
        }
        return null;
    }

    static {
        CopyOnWriteArrayList<Module> list = new CopyOnWriteArrayList<Module>();
        SecurityManager sm = System.getSecurityManager();
        String urlModulesList = sm != null ? AccessController.doPrivileged(CONTENT_MODULES_LIST_ACTION) : CONTENT_MODULES_LIST_ACTION.run();
        if (urlModulesList != null) {
            int i;
            ArrayList<Module> moduleList = new ArrayList<Module>();
            int f = 0;
            do {
                String moduleId;
                if (!(moduleId = ((i = urlModulesList.indexOf(124, f)) == -1 ? urlModulesList.substring(f) : urlModulesList.substring(f, i)).trim()).isEmpty()) {
                    try {
                        Module module = Module.getBootModuleLoader().loadModule(moduleId);
                        moduleList.add(module);
                    }
                    catch (RuntimeException | ModuleLoadException exception) {
                        // empty catch block
                    }
                }
                f = i + 1;
            } while (i != -1);
            list.addAll(moduleList);
        }
        modules = list;
        INSTANCE = new ModularContentHandlerFactory();
    }
}

