/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.converter.Converter;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.option.Option;
import org.aesh.command.validator.OptionValidatorException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.patching.cli.CandidatesProviders;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.tool.PatchOperationBuilder;
import org.jboss.as.patching.tool.PatchOperationTarget;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.cli.command.aesh.CLICompleterInvocation;
import org.wildfly.core.cli.command.aesh.CLIConverterInvocation;
import org.wildfly.core.cli.command.aesh.activator.AbstractOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.DomainOptionActivator;
import org.wildfly.security.manager.action.ReadEnvironmentPropertyAction;
import org.wildfly.security.manager.action.ReadPropertyAction;

@CommandDefinition(name="abstract-distribution-cmd", description="")
public abstract class AbstractDistributionCommand
implements Command<CLICommandInvocation> {
    @Option(completer=HostsCompleter.class, activator=HostsActivator.class)
    private String host;
    @Option(required=false, activator=DisconnectedActivator.class)
    private File distribution;
    @Option(name="module-path", completer=FilePathCompleter.class, converter=FilePathConverter.class, required=false, activator=DisconnectedActivator.class)
    private List<File> modulePath;
    @Option(name="bundle-path", converter=FilePathConverter.class, required=false)
    private List<File> bundlePath;
    private final String action;
    static final String lineSeparator = System.getSecurityManager() == null ? System.getProperty("line.separator") : (String)AccessController.doPrivileged(new ReadPropertyAction("line.separator"));
    private static final String HOME = "JBOSS_HOME";
    private static final String HOME_DIR = "jboss.home.dir";

    protected AbstractDistributionCommand(String action) {
        this.action = action;
    }

    String getHost() {
        return this.host;
    }

    String getPatchStream() {
        return null;
    }

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        ModelNode response;
        if (this.host != null && !commandInvocation.getCommandContext().isDomainMode()) {
            throw new CommandException("The --host option is not available in the current context. Connection to the controller might be unavailable or not running in domain mode.");
        }
        if (this.host == null && commandInvocation.getCommandContext().isDomainMode()) {
            throw new CommandException("The --host option must be used in domain mode.");
        }
        try {
            this.verifyManagementVersion(commandInvocation);
        }
        catch (IOException e) {
            throw new CommandException(this.action + " failed", (Throwable)e);
        }
        PatchOperationTarget target = this.createPatchOperationTarget(commandInvocation.getCommandContext());
        PatchOperationBuilder builder = this.createPatchOperationBuilder(commandInvocation.getCommandContext());
        try {
            response = builder.execute(target);
        }
        catch (Exception e) {
            throw new CommandException(this.action + " failed", (Throwable)e);
        }
        if (!Util.isSuccess((ModelNode)response)) {
            ModelNode fd = response.get("failure-description");
            if (!fd.isDefined()) {
                throw new CommandException("Failed to apply patch: " + response.asString());
            }
            if (fd.has("conflicts")) {
                StringBuilder buf = new StringBuilder();
                buf.append(fd.get("message").asString()).append(": ");
                ModelNode conflicts = fd.get("conflicts");
                String title = "";
                if (conflicts.has("bundles")) {
                    AbstractDistributionCommand.formatConflictsList(buf, conflicts, "", "bundles");
                    title = ", ";
                }
                if (conflicts.has("modules")) {
                    AbstractDistributionCommand.formatConflictsList(buf, conflicts, title, "modules");
                    title = ", ";
                }
                if (conflicts.has("misc")) {
                    AbstractDistributionCommand.formatConflictsList(buf, conflicts, title, "misc");
                }
                buf.append(lineSeparator).append("Use the --override-all, --override=[] or --preserve=[] arguments in order to resolve the conflict.");
                throw new CommandException(buf.toString());
            }
            throw new CommandException(Util.getFailureDescription((ModelNode)response));
        }
        this.handleResponse(commandInvocation.getCommandContext(), response);
        return CommandResult.SUCCESS;
    }

    protected void handleResponse(CommandContext ctx, ModelNode response) throws CommandException {
        ctx.printLine(response.toJSONString(false));
    }

    protected abstract PatchOperationBuilder createPatchOperationBuilder(CommandContext var1) throws CommandException;

    PatchOperationTarget createPatchOperationTarget(CommandContext ctx) throws CommandException {
        PatchOperationTarget target;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (ctx.getModelControllerClient() != null) {
            if (this.distribution != null) {
                throw new CommandException("--distribution is not allowed when connected to the controller.");
            }
            if (this.modulePath != null) {
                throw new CommandException("--module-path is not allowed when connected to the controller.");
            }
            if (this.bundlePath != null) {
                throw new CommandException("--bundle-path is not allowed when connected to the controller.");
            }
            target = ctx.isDomainMode() ? PatchOperationTarget.createHost(this.host, ctx.getModelControllerClient()) : PatchOperationTarget.createStandalone(ctx.getModelControllerClient());
        } else {
            File root = this.getJBossHome();
            List<File> modules = AbstractDistributionCommand.getFSArgument(this.modulePath, args, root, "modules");
            List<File> bundles = AbstractDistributionCommand.getFSArgument(this.bundlePath, args, root, "bundles");
            try {
                target = PatchOperationTarget.createLocal(root, modules, bundles);
            }
            catch (Exception e) {
                throw new CommandException("Unable to apply patch to local JBOSS_HOME=" + String.valueOf(root), (Throwable)e);
            }
        }
        return target;
    }

    private File getJBossHome() {
        String resolved;
        if (this.distribution != null) {
            return this.distribution;
        }
        String string = resolved = System.getSecurityManager() == null ? System.getenv(HOME) : (String)AccessController.doPrivileged(new ReadEnvironmentPropertyAction(HOME));
        if (resolved == null) {
            String string2 = resolved = System.getSecurityManager() == null ? System.getProperty(HOME_DIR) : (String)AccessController.doPrivileged(new ReadPropertyAction(HOME_DIR));
        }
        if (resolved == null) {
            throw PatchLogger.ROOT_LOGGER.cliFailedToResolveDistribution();
        }
        return new File(resolved);
    }

    private static List<File> getFSArgument(List<File> files, ParsedCommandLine args, File root, String param) {
        if (files != null) {
            return files;
        }
        return Collections.singletonList(new File(root, param));
    }

    private static void formatConflictsList(StringBuilder buf, ModelNode conflicts, String title, String contentType) {
        buf.append(title);
        List list = conflicts.get(contentType).asList();
        int i = 0;
        while (i < list.size()) {
            ModelNode item = (ModelNode)list.get(i++);
            buf.append(item.asString());
            if (i >= list.size()) continue;
            buf.append(", ");
        }
    }

    private void verifyManagementVersion(CLICommandInvocation commandInvocation) throws IOException, CommandException {
        if (commandInvocation.getCommandContext().isDomainMode()) {
            ModelControllerClient client = commandInvocation.getCommandContext().getModelControllerClient();
            commandInvocation.getCommandContext().getModelControllerClient();
            ModelNode op = new ModelNode();
            PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.host)});
            op.get("address").set(address.toModelNode());
            op.get("operation").set("query");
            ModelNode select = new ModelNode().addEmptyList();
            select.add("management-major-version");
            op.get("select").set(select);
            ModelNode response = client.execute(op);
            int major = response.get(new String[]{"result", "management-major-version"}).asInt();
            if (major > 20) {
                throw new CommandException("The 'patch' command is not supported on this host controller. For the '" + this.host + "' host you have to use the 'installer' tool instead.");
            }
        }
    }

    public static class HostsCompleter
    implements OptionCompleter<CLICompleterInvocation> {
        public void complete(CLICompleterInvocation completerInvocation) {
            ArrayList<String> values = new ArrayList<String>();
            Collection<String> candidates = this.getCandidates(completerInvocation.getCommandContext());
            String opBuffer = completerInvocation.getGivenCompleteValue();
            if (opBuffer.isEmpty()) {
                values.addAll(candidates);
            } else {
                for (String name : candidates) {
                    if (!name.startsWith(opBuffer)) continue;
                    values.add(name);
                }
                Collections.sort(values);
            }
            completerInvocation.addAllCompleterValues(values);
        }

        private Collection<String> getCandidates(CommandContext ctx) {
            return CandidatesProviders.HOSTS.getAllCandidates(ctx);
        }
    }

    public static class DisconnectedActivator
    extends AbstractOptionActivator {
        public boolean isActivated(ParsedCommand processedCommand) {
            return this.getCommandContext().getModelControllerClient() == null;
        }
    }

    public static class HostsActivator
    extends AbstractOptionActivator
    implements DomainOptionActivator {
        public boolean isActivated(ParsedCommand processedCommand) {
            return this.getCommandContext().getModelControllerClient() != null && this.getCommandContext().isDomainMode();
        }
    }

    public static class FilePathCompleter
    implements OptionCompleter<CLICompleterInvocation> {
        public void complete(CLICompleterInvocation completerInvocation) {
            ArrayList candidates = new ArrayList();
            String[] values = completerInvocation.getGivenCompleteValue().split(Pattern.quote(File.pathSeparator));
            String path = values[values.length - 1];
            FilenameTabCompleter pathCompleter = FilenameTabCompleter.newCompleter((CommandContext)completerInvocation.getCommandContext());
            int cursor = pathCompleter.complete(completerInvocation.getCommandContext(), path, path.length(), candidates);
            completerInvocation.addAllCompleterValues(candidates);
            completerInvocation.setOffset(completerInvocation.getGivenCompleteValue().length() - cursor);
            completerInvocation.setAppendSpace(false);
        }
    }

    public static class FilePathConverter
    implements Converter<List<File>, CLIConverterInvocation> {
        public List<File> convert(CLIConverterInvocation converterInvocation) throws OptionValidatorException {
            String[] values = converterInvocation.getInput().split(Pattern.quote(File.pathSeparator));
            CommandContext ctx = converterInvocation.getCommandContext();
            ArrayList<File> files = new ArrayList<File>();
            for (String value : values) {
                File f;
                FilenameTabCompleter pathCompleter = FilenameTabCompleter.newCompleter((CommandContext)ctx);
                if (value == null) continue;
                if (value.length() >= 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(1, value.length() - 1);
                }
                if (!(f = new File(value = pathCompleter.translatePath(value))).exists()) {
                    throw new OptionValidatorException("File " + f.getAbsolutePath() + " does not exist.");
                }
                files.add(f);
            }
            return files;
        }
    }
}

