/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.logging.PatchLogger;

public class ZipUtils {
    public static void zip(File sourceDir, File zipFile) {
        try (FileOutputStream os = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(os));){
            for (File file : sourceDir.listFiles()) {
                if (file.isDirectory()) {
                    ZipUtils.addDirectoryToZip(file, file.getName(), zos);
                    continue;
                }
                ZipUtils.addFileToZip(file, null, zos);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed creating patch file " + String.valueOf(zipFile), e);
        }
    }

    private static void addDirectoryToZip(File dir, String dirName, ZipOutputStream zos) throws IOException {
        ZipEntry dirEntry = new ZipEntry(dirName + "/");
        zos.putNextEntry(dirEntry);
        zos.closeEntry();
        File[] children = dir.listFiles();
        if (children != null) {
            for (File file : children) {
                if (file.isDirectory()) {
                    ZipUtils.addDirectoryToZip(file, dirName + "/" + file.getName(), zos);
                    continue;
                }
                ZipUtils.addFileToZip(file, dirName, zos);
            }
        }
    }

    private static void addFileToZip(File file, String parent, ZipOutputStream zos) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            String entryName = parent == null ? file.getName() : parent + "/" + file.getName();
            zos.putNextEntry(new ZipEntry(entryName));
            try (BufferedInputStream bis = new BufferedInputStream(is);){
                IoUtils.copyStream(bis, zos);
            }
            zos.closeEntry();
        }
    }

    public static void unzip(File zip, File patchDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            ZipUtils.unzip(zipFile, patchDir);
        }
    }

    private static void unzip(ZipFile zip, File patchDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            File current = new File(patchDir, name);
            if (!current.getCanonicalFile().toPath().startsWith(patchDir.getCanonicalFile().toPath())) {
                throw PatchLogger.ROOT_LOGGER.entryOutsideOfPatchDirectory(current.getCanonicalPath());
            }
            if (entry.isDirectory()) continue;
            if (!current.getParentFile().exists()) {
                current.getParentFile().mkdirs();
            }
            InputStream eis = zip.getInputStream(entry);
            try {
                Files.copy(eis, current.toPath(), new CopyOption[0]);
            }
            finally {
                if (eis == null) continue;
                eis.close();
            }
        }
    }
}

