/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.DoubleToIntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongToIntFunction;
import java.util.function.ToIntFunction;
import org.wildfly.clustering.function.BooleanSupplier;
import org.wildfly.clustering.function.DoublePredicate;
import org.wildfly.clustering.function.IntConsumer;
import org.wildfly.clustering.function.LongPredicate;
import org.wildfly.clustering.function.Predicate;

public interface IntPredicate
extends java.util.function.IntPredicate {
    public static final IntPredicate ALWAYS = IntPredicate.of(IntConsumer.EMPTY, BooleanSupplier.TRUE);
    public static final IntPredicate NEVER = IntPredicate.of(IntConsumer.EMPTY, BooleanSupplier.FALSE);
    public static final IntPredicate POSITIVE = IntPredicate.greaterThan(0);
    public static final IntPredicate ZERO = IntPredicate.equalTo(0);
    public static final IntPredicate NEGATIVE = IntPredicate.lessThan(0);

    default public <V> Predicate<V> compose(final ToIntFunction<V> composer) {
        return new Predicate<V>(){

            @Override
            public boolean test(V value) {
                return IntPredicate.this.test(composer.applyAsInt(value));
            }
        };
    }

    default public DoublePredicate composeDouble(final DoubleToIntFunction composer) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return IntPredicate.this.test(composer.applyAsInt(value));
            }
        };
    }

    default public IntPredicate composeInt(final IntUnaryOperator composer) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return IntPredicate.this.test(composer.applyAsInt(value));
            }
        };
    }

    default public LongPredicate composeLong(final LongToIntFunction composer) {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return IntPredicate.this.test(composer.applyAsInt(value));
            }
        };
    }

    @Override
    default public IntPredicate and(final java.util.function.IntPredicate other) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return IntPredicate.this.test(value) && other.test(value);
            }
        };
    }

    @Override
    default public IntPredicate negate() {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return !IntPredicate.this.test(value);
            }
        };
    }

    @Override
    default public IntPredicate or(final java.util.function.IntPredicate other) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return IntPredicate.this.test(value) || other.test(value);
            }
        };
    }

    default public IntPredicate xor(final java.util.function.IntPredicate other) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return IntPredicate.this.test(value) ^ other.test(value);
            }
        };
    }

    public static IntPredicate of(boolean result) {
        return result ? ALWAYS : NEVER;
    }

    public static IntPredicate of(final java.util.function.IntConsumer consumer, final java.util.function.BooleanSupplier supplier) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                consumer.accept(value);
                return supplier.getAsBoolean();
            }
        };
    }

    public static IntPredicate lessThan(final int base) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return Integer.compare(value, base) < 0;
            }
        };
    }

    public static IntPredicate equalTo(final int base) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return Integer.compare(base, value) == 0;
            }
        };
    }

    public static IntPredicate greaterThan(final int base) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return Integer.compare(value, base) > 0;
            }
        };
    }
}

