/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class InfoHeader
extends Header {
    protected Map<String, String> info = new HashMap<String, String>();
    public static short ID = (short)1234;

    @Override
    public short getMagicId() {
        return 101;
    }

    @Override
    public Supplier<? extends Header> create() {
        return InfoHeader::new;
    }

    public String get(String key) {
        return this.info.get(key);
    }

    public InfoHeader put(String key, String value) {
        this.info.put(key, value);
        return this;
    }

    public InfoHeader clear() {
        this.info.clear();
        return this;
    }

    @Override
    public int serializedSize() {
        int retval = 4;
        if (!this.info.isEmpty()) {
            for (Map.Entry<String, String> e : this.info.entrySet()) {
                retval += Util.size(e.getKey()) + Util.size(e.getValue());
            }
        }
        return retval;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.info.size());
        for (Map.Entry<String, String> e : this.info.entrySet()) {
            Bits.writeString(e.getKey(), out);
            Bits.writeString(e.getValue(), out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = Bits.readString(in);
            String value = Bits.readString(in);
            this.info.put(key, value);
        }
    }

    @Override
    public String toString() {
        return this.info.toString();
    }
}

