/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.impl;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.utils.DurationUtils;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingServiceDiscovery
implements ServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(CachingServiceDiscovery.class);
    public static final String REFRESH_PERIOD = "refresh-period";
    public final Duration refreshPeriod;
    public static final String DEFAULT_REFRESH_INTERVAL = "5M";
    private volatile List<ServiceInstance> lastResults;
    private final AtomicReference<Uni<List<ServiceInstance>>> instances = new AtomicReference();

    public CachingServiceDiscovery(String refreshPeriod) {
        try {
            this.refreshPeriod = DurationUtils.parseDuration(refreshPeriod, REFRESH_PERIOD);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("refresh-period for service discovery should be a number, got: " + refreshPeriod, e);
        }
        this.lastResults = Collections.emptyList();
        Uni retrieval = Uni.createFrom().deferred(() -> this.fetchNewServiceInstances(this.lastResults).invoke(l -> {
            this.lastResults = l;
        }).onFailure().invoke(this::handleFetchError).onFailure().recoverWithItem(this.lastResults));
        this.instances.compareAndSet(null, this.cache((Uni<List<ServiceInstance>>)retrieval));
    }

    public Uni<List<ServiceInstance>> cache(Uni<List<ServiceInstance>> uni) {
        return uni.memoize().atLeast(this.refreshPeriod);
    }

    public void invalidate() {
        this.instances.set(null);
    }

    public Uni<List<ServiceInstance>> getServiceInstances() {
        Uni newInstances;
        Uni<List<ServiceInstance>> current = this.instances.get();
        if (current == null && this.instances.compareAndSet(current, (Uni<List<ServiceInstance>>)(newInstances = this.fetchNewServiceInstances(this.lastResults).invoke(l -> {
            this.lastResults = l;
        }).onFailure().invoke(this::handleFetchError).onFailure().recoverWithItem(this.lastResults)))) {
            this.instances.set(this.cache((Uni<List<ServiceInstance>>)newInstances));
            return newInstances;
        }
        return this.instances.get();
    }

    private void handleFetchError(Throwable error) {
        log.error("Failed to fetch service instances", error);
    }

    public abstract Uni<List<ServiceInstance>> fetchNewServiceInstances(List<ServiceInstance> var1);
}

