/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.util.Iterator;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;

public class CacheKeysTask<K, V>
implements Consumer<CacheStreamFilter<K>> {
    private final Cache<K, V> cache;
    private final Predicate<? super K> filter;
    private final Consumer<K> task;

    public static <K, V> Consumer<CacheStreamFilter<K>> cancel(Cache<K, V> cache, Predicate<? super K> filter, CacheEntryScheduler<K, V> scheduler) {
        return new CacheKeysTask<K, V>(cache, filter, scheduler::cancelKey);
    }

    CacheKeysTask(Cache<K, V> cache, Predicate<? super K> filter, Consumer<K> task) {
        this.cache = cache;
        this.filter = filter;
        this.task = task;
    }

    public void accept(CacheStreamFilter<K> filter) {
        try (CacheStream stream = ((CacheStream)filter.apply((Object)this.cache.keySet().stream())).filter(this.filter);){
            Iterator keys = stream.iterator();
            while (keys.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                this.task.accept(keys.next());
            }
        }
    }
}

