/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.features.throttling;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.cxf.message.Message;
import org.apache.cxf.throttling.ThrottleResponse;
import org.apache.cxf.throttling.ThrottlingManager;

public class RateLimitThorttlingManager
extends ThrottleResponse
implements ThrottlingManager {
    private AtomicLong[] requestTime = new AtomicLong[60];
    private AtomicInteger[] requestCount = new AtomicInteger[60];
    private AtomicBoolean firstMessage = new AtomicBoolean(false);
    private int permitsPerMin = Integer.MAX_VALUE;
    private int period = 60;
    private int permitsPerPeriod = Integer.MAX_VALUE;

    public void setPeriod(int seconds) {
        this.period = seconds;
    }

    public void setPermitsPerPeriod(int permitsPerPeriod) {
        this.permitsPerPeriod = permitsPerPeriod;
    }

    public int getPermitsPerMin() {
        return this.permitsPerMin;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getPermitsPerPeriod() {
        return this.permitsPerPeriod;
    }

    public void setPermitsPerMin(int permitsPerMin) {
        this.period = 60;
        this.permitsPerPeriod = permitsPerMin;
    }

    public RateLimitThorttlingManager() {
        for (int i = 0; i < this.getPeriod(); ++i) {
            this.requestTime[i] = new AtomicLong(0L);
            this.requestCount[i] = new AtomicInteger(0);
        }
    }

    public List<String> getDecisionPhases() {
        return Collections.singletonList("pre-stream");
    }

    public ThrottleResponse getThrottleResponse(String phase, Message m) {
        long currentTime = System.currentTimeMillis();
        int currentIndex = (int)(currentTime / 1000L % (long)this.getPeriod());
        this.requestTime[currentIndex].set(currentTime);
        this.requestCount[currentIndex].incrementAndGet();
        if (this.firstMessage.compareAndSet(false, true)) {
            return null;
        }
        for (int i = 0; i < this.getPeriod(); ++i) {
            AtomicLong item = this.requestTime[i];
            if (item.get() <= 0L || currentTime - item.get() <= (long)(this.getPeriod() * 1000)) continue;
            this.requestTime[i].set(0L);
            this.requestCount[i].set(0);
        }
        int sum = Stream.of(this.requestCount).mapToInt(AtomicInteger::get).sum();
        if (sum > this.permitsPerPeriod) {
            this.setResponseCode(429);
            return this;
        }
        return null;
    }
}

