/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import org.jboss.ejb.client.ClusterNodeSelector;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

public final class EJBClientCluster {
    private final String name;
    private final long maximumConnectedNodes;
    private final long connectTimeoutMilliseconds;
    private final ClusterNodeSelector clusterNodeSelector;
    private final AuthenticationConfiguration overrideConfiguration;

    EJBClientCluster(Builder builder) {
        this.name = builder.name;
        this.maximumConnectedNodes = builder.maximumConnectedNodes;
        this.connectTimeoutMilliseconds = builder.connectTimeoutMilliseconds;
        this.clusterNodeSelector = builder.clusterNodeSelector;
        this.overrideConfiguration = builder.overrideConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public long getMaximumConnectedNodes() {
        return this.maximumConnectedNodes;
    }

    public long getConnectTimeoutMilliseconds() {
        return this.connectTimeoutMilliseconds;
    }

    public ClusterNodeSelector getClusterNodeSelector() {
        return this.clusterNodeSelector;
    }

    public AuthenticationConfiguration getOverrideConfiguration() {
        return this.overrideConfiguration;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EJBClientCluster(name=");
        builder.append(this.name);
        builder.append(", max nodes=");
        builder.append(this.maximumConnectedNodes);
        builder.append(", connect timeout milis=");
        builder.append(this.connectTimeoutMilliseconds);
        builder.append(", selector=");
        builder.append(this.clusterNodeSelector);
        builder.append(", override config=");
        builder.append(this.overrideConfiguration);
        builder.append(")");
        return builder.toString();
    }

    public static final class Builder {
        private String name;
        private long maximumConnectedNodes = 0L;
        private long connectTimeoutMilliseconds = -1L;
        private ClusterNodeSelector clusterNodeSelector;
        private AuthenticationConfiguration overrideConfiguration;

        public Builder setName(String name) {
            Assert.checkNotNullParam((String)"name", (Object)name);
            this.name = name;
            return this;
        }

        public Builder setMaximumConnectedNodes(long maximumConnectedNodes) {
            Assert.checkMinimumParameter((String)"maximumConnectedNodes", (long)0L, (long)maximumConnectedNodes);
            this.maximumConnectedNodes = maximumConnectedNodes;
            return this;
        }

        public Builder setConnectTimeoutMilliseconds(long connectTimeoutMilliseconds) {
            Assert.checkMinimumParameter((String)"connectTimeoutMilliseconds", (long)-1L, (long)connectTimeoutMilliseconds);
            this.connectTimeoutMilliseconds = connectTimeoutMilliseconds;
            return this;
        }

        public Builder setClusterNodeSelector(ClusterNodeSelector clusterNodeSelector) {
            this.clusterNodeSelector = clusterNodeSelector;
            return this;
        }

        public Builder setOverrideConfiguration(AuthenticationConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        public EJBClientCluster build() {
            Assert.checkNotNullParam((String)"name", (Object)this.name);
            return new EJBClientCluster(this);
        }
    }
}

