/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.operators;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import mutiny.zero.internal.Helper;

public class Concatenate<T>
implements Flow.Publisher<T> {
    private final List<Flow.Publisher<T>> publishers;

    public Concatenate(List<Flow.Publisher<T>> publishers) {
        this.publishers = Objects.requireNonNull(publishers, "The publishers list cannot be null");
        for (Flow.Publisher<T> publisher : publishers) {
            Objects.requireNonNull(publisher, "A publisher cannot be null");
        }
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        Processor processor = new Processor();
        processor.subscribe(subscriber);
    }

    private class Processor
    implements Flow.Processor<T, T>,
    Flow.Subscription {
        private Flow.Subscriber<? super T> downstream;
        private Flow.Subscription upstreamSubscription;
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final AtomicLong demand = new AtomicLong();
        private volatile boolean unboundedDemand;
        private boolean downstreamIsReady;
        private final Iterator<Flow.Publisher<T>> publisherIterator;

        private Processor() {
            this.publisherIterator = Concatenate.this.publishers.iterator();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> subscriber) {
            this.downstream = subscriber;
            this.subscribeNext();
        }

        private void subscribeNext() {
            if (this.publisherIterator.hasNext()) {
                Flow.Publisher publisher = this.publisherIterator.next();
                publisher.subscribe(this);
            } else {
                this.downstream.onComplete();
            }
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.cancelled.get()) {
                return;
            }
            this.upstreamSubscription = subscription;
            if (this.downstreamIsReady) {
                long n = this.demand.get();
                if (n > 0L) {
                    this.upstreamSubscription.request(n);
                }
            } else {
                this.downstreamIsReady = true;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T item) {
            if (!this.cancelled.get()) {
                if (!this.unboundedDemand) {
                    this.demand.decrementAndGet();
                }
                this.downstream.onNext(item);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (!this.cancelled.get()) {
                this.cancel();
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (!this.cancelled.get()) {
                this.subscribeNext();
            }
        }

        @Override
        public void request(long n) {
            if (this.cancelled.get()) {
                return;
            }
            if (n <= 0L) {
                this.onError(Helper.negativeRequest(n));
            } else {
                Helper.add(this.demand, n);
                if (n == Long.MAX_VALUE) {
                    this.unboundedDemand = true;
                }
                this.upstreamSubscription.request(n);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.upstreamSubscription.cancel();
                this.upstreamSubscription = null;
            }
        }
    }
}

