/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.faulttolerance.deployment;

import io.smallrye.faulttolerance.FaultToleranceExtension;
import io.smallrye.faulttolerance.metrics.MetricsIntegration;
import jakarta.enterprise.inject.spi.Extension;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.wildfly.extension.microprofile.faulttolerance.MicroProfileFaultToleranceLogger;
import org.wildfly.extension.microprofile.faulttolerance.deployment.MicroProfileFaultToleranceMarker;

public class MicroProfileFaultToleranceDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) {
        WeldCapability weldCapability;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!MicroProfileFaultToleranceMarker.isMarked(deploymentUnit)) {
            return;
        }
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        try {
            weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw new IllegalStateException();
        }
        Set registeredSubsystems = (Set)deploymentUnit.getAttachment(Attachments.REGISTERED_SUBSYSTEMS);
        HashSet<MetricsIntegration> metricsIntegrations = new HashSet<MetricsIntegration>();
        if (registeredSubsystems.contains("microprofile-telemetry")) {
            metricsIntegrations.add(MetricsIntegration.OPENTELEMETRY);
        }
        if (registeredSubsystems.contains("micrometer")) {
            metricsIntegrations.add(MetricsIntegration.MICROMETER);
        }
        if (metricsIntegrations.isEmpty()) {
            metricsIntegrations.add(MetricsIntegration.NOOP);
        }
        MicroProfileFaultToleranceLogger.ROOT_LOGGER.metricsProvider(metricsIntegrations.stream().map(Enum::name).collect(Collectors.toSet()));
        weldCapability.registerExtensionInstance((Extension)new FaultToleranceExtension(metricsIntegrations), deploymentUnit);
    }
}

