/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.runtime.bytecode;

import java.util.Objects;
import java.util.Set;
import org.wildfly.unstable.api.annotation.classpath.index.RuntimeIndex;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsageType;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationWithSourceClassUsage;

public class AnnotatedFieldReference
extends AnnotationWithSourceClassUsage {
    private final String fieldClass;
    private final String fieldName;

    AnnotatedFieldReference(Set<String> annotations, String className, String fieldClass, String fieldName) {
        super(annotations, AnnotationUsageType.FIELD_REFERENCE, className);
        this.fieldClass = fieldClass;
        this.fieldName = fieldName;
    }

    public String getFieldClass() {
        return this.fieldClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnnotatedFieldReference that = (AnnotatedFieldReference)o;
        return Objects.equals(this.fieldClass, that.fieldClass) && Objects.equals(this.fieldName, that.fieldName);
    }

    @Override
    protected int calculateHash() {
        return Objects.hash(super.calculateHash(), this.fieldClass, this.fieldName);
    }

    @Override
    protected AnnotationUsage convertToDotFormat() {
        return new AnnotatedFieldReference(this.annotations, RuntimeIndex.convertClassNameToDotFormat(this.sourceClass), RuntimeIndex.convertClassNameToDotFormat(this.fieldClass), this.fieldName);
    }
}

