/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.rmi;

import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.TransactionRequiredException;
import jakarta.transaction.TransactionRolledbackException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Arrays;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.portable.IDLEntity;

public class RmiIdlUtil {
    public static boolean hasLegalRMIIIOPArguments(Method method) {
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (RmiIdlUtil.isRMIIIOPType(params[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasLegalRMIIIOPReturnType(Method method) {
        return RmiIdlUtil.isRMIIIOPType(method.getReturnType());
    }

    public static boolean hasLegalRMIIIOPExceptionTypes(Method method) {
        for (Class<?> exception : Arrays.asList(method.getExceptionTypes())) {
            if (RmiIdlUtil.isRMIIDLExceptionType(exception)) continue;
            return false;
        }
        return true;
    }

    public static boolean throwsRemoteException(Method method) {
        Class<?>[] exception = method.getExceptionTypes();
        for (int i = 0; i < exception.length; ++i) {
            if (!exception[i].isAssignableFrom(RemoteException.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isStatic(Class c) {
        return Modifier.isStatic(c.getModifiers());
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isFinal(Class c) {
        return Modifier.isFinal(c.getModifiers());
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPublic(Class c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static boolean isAllFieldsPublic(Class c) {
        try {
            Field[] list = c.getFields();
            for (int i = 0; i < list.length; ++i) {
                if (Modifier.isPublic(list[i].getModifiers())) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isAbstract(Class c) {
        return Modifier.isAbstract(c.getModifiers());
    }

    public static boolean isRMIIIOPType(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return RmiIdlUtil.isRMIIIOPType(type.getComponentType());
        }
        if (Object.class.isAssignableFrom(type)) {
            return true;
        }
        if (IDLEntity.class.isAssignableFrom(type)) {
            return true;
        }
        if (RmiIdlUtil.isRMIIDLRemoteInterface(type)) {
            return true;
        }
        if (RmiIdlUtil.isRMIIDLExceptionType(type)) {
            return true;
        }
        return RmiIdlUtil.isRMIIDLValueType(type);
    }

    public static boolean isRMIIDLRemoteInterface(Class type) {
        if (!Remote.class.isAssignableFrom(type)) {
            return false;
        }
        for (Method m : Arrays.asList(type.getMethods())) {
            if (!RmiIdlUtil.throwsRemoteException(m)) {
                return false;
            }
            for (Class<?> exception : Arrays.asList(m.getExceptionTypes())) {
                if (RmiIdlUtil.isRMIIDLExceptionType(exception)) continue;
                return false;
            }
        }
        for (Field f : Arrays.asList(type.getFields())) {
            if (f.getType().isPrimitive() || f.getType().equals(String.class)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAbstractInterface(Class type) {
        if (!type.isInterface()) {
            return false;
        }
        if (Object.class.isAssignableFrom(type)) {
            return false;
        }
        if (Remote.class.isAssignableFrom(type)) {
            return false;
        }
        for (Method m : Arrays.asList(type.getMethods())) {
            if (RmiIdlUtil.throwsRemoteException(m)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRMIIDLExceptionType(Class type) {
        if (!Throwable.class.isAssignableFrom(type)) {
            return false;
        }
        if (Error.class.isAssignableFrom(type)) {
            return false;
        }
        if (RuntimeException.class.isAssignableFrom(type)) {
            return false;
        }
        return RmiIdlUtil.isRMIIDLValueType(type);
    }

    public static boolean isRMIIDLValueType(Class type) {
        if (Remote.class.isAssignableFrom(type)) {
            return false;
        }
        if (Object.class.isAssignableFrom(type)) {
            return false;
        }
        return type.getDeclaringClass() == null || !RmiIdlUtil.isStatic(type) || RmiIdlUtil.isRMIIDLValueType(type.getDeclaringClass());
    }

    public static boolean isAbstractValueType(Class type) {
        if (!type.isInterface()) {
            return false;
        }
        if (Object.class.isAssignableFrom(type)) {
            return false;
        }
        boolean cannotBeRemote = false;
        boolean cannotBeAbstractInterface = false;
        if (Remote.class.isAssignableFrom(type)) {
            cannotBeAbstractInterface = true;
        } else {
            cannotBeRemote = true;
        }
        block0: for (Method m : Arrays.asList(type.getMethods())) {
            if (!RmiIdlUtil.throwsRemoteException(m)) {
                cannotBeAbstractInterface = true;
                cannotBeRemote = true;
                break;
            }
            for (Class<?> exception : Arrays.asList(m.getExceptionTypes())) {
                if (RmiIdlUtil.isRMIIDLExceptionType(exception)) continue;
                cannotBeRemote = true;
                continue block0;
            }
        }
        if (!cannotBeRemote) {
            for (Field f : Arrays.asList(type.getFields())) {
                if (f.getType().isPrimitive() || f.getType().equals(String.class)) continue;
                cannotBeRemote = true;
                break;
            }
        }
        return cannotBeRemote && cannotBeAbstractInterface;
    }

    public static void rethrowIfCorbaSystemException(Throwable e) {
        java.lang.Object re;
        if (e instanceof MarshalException) {
            re = new MARSHAL(e.toString());
        } else if (e instanceof NoSuchObjectException) {
            re = new OBJECT_NOT_EXIST(e.toString());
        } else if (e instanceof AccessException) {
            re = new NO_PERMISSION(e.toString());
        } else if (e instanceof TransactionRequiredException) {
            re = new TRANSACTION_REQUIRED(e.toString());
        } else if (e instanceof TransactionRolledbackException) {
            re = new TRANSACTION_ROLLEDBACK(e.toString());
        } else if (e instanceof InvalidTransactionException) {
            re = new INVALID_TRANSACTION(e.toString());
        } else if (e instanceof SystemException) {
            re = (SystemException)e;
        } else {
            return;
        }
        re.setStackTrace(e.getStackTrace());
        throw re;
    }
}

