/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.marshalling.protostream.AbstractSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.Scalar;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.time.DurationMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalDateMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalDateTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.MonthDayMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.OffsetDateTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.OffsetTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.PeriodMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.YearMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.YearMonthMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.ZoneOffsetMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.ZonedDateTimeMarshaller;

public class TimeSerializationContextInitializer
extends AbstractSerializationContextInitializer {
    public TimeSerializationContextInitializer() {
        super(Instant.class.getPackage());
    }

    @Override
    public void registerMarshallers(SerializationContext context) {
        context.registerMarshaller(ProtoStreamMarshaller.of(DayOfWeek.class));
        ProtoStreamMarshaller<Duration> durationMarshaller = DurationMarshaller.INSTANCE.asMarshaller();
        context.registerMarshaller(durationMarshaller);
        context.registerMarshaller(durationMarshaller.wrap(Instant.class, instant -> Duration.ofSeconds(instant.getEpochSecond(), instant.getNano()), duration -> Instant.ofEpochSecond(duration.getSeconds(), duration.getNano())));
        context.registerMarshaller(LocalDateMarshaller.INSTANCE.asMarshaller());
        context.registerMarshaller(LocalDateTimeMarshaller.INSTANCE);
        context.registerMarshaller(LocalTimeMarshaller.INSTANCE.asMarshaller());
        context.registerMarshaller(ProtoStreamMarshaller.of(Month.class));
        context.registerMarshaller(MonthDayMarshaller.INSTANCE);
        context.registerMarshaller(OffsetDateTimeMarshaller.INSTANCE);
        context.registerMarshaller(OffsetTimeMarshaller.INSTANCE);
        context.registerMarshaller(PeriodMarshaller.INSTANCE);
        context.registerMarshaller(YearMarshaller.INSTANCE.asMarshaller());
        context.registerMarshaller(YearMonthMarshaller.INSTANCE);
        context.registerMarshaller(Scalar.STRING.cast(String.class).toMarshaller(ZoneId.class, ZoneId::getId, Supplier.of((Object)ZoneOffset.UTC), ZoneId::of));
        context.registerMarshaller(ZoneOffsetMarshaller.INSTANCE.asMarshaller());
        context.registerMarshaller(ZonedDateTimeMarshaller.INSTANCE);
    }
}

