/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.net;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.protostream.AbstractSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.Scalar;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.net.InetAddressMarshaller;
import org.wildfly.clustering.marshalling.protostream.net.InetSocketAddressMarshaller;

public class NetSerializationContextInitializer
extends AbstractSerializationContextInitializer {
    public NetSerializationContextInitializer() {
        super(URI.class.getPackage());
    }

    @Override
    public void registerMarshallers(SerializationContext context) {
        context.registerMarshaller(InetAddressMarshaller.INSTANCE.asMarshaller(InetAddress.class));
        context.registerMarshaller(InetSocketAddressMarshaller.INSTANCE);
        ProtoStreamMarshaller<URI> uriMarshaller = Scalar.STRING.cast(String.class).toMarshaller(URI.class, URI::toString, URI::create);
        context.registerMarshaller(uriMarshaller);
        context.registerMarshaller(uriMarshaller.wrap(URL.class, new Function<URL, URI>(){

            @Override
            public URI apply(URL url) {
                try {
                    return url.toURI();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }, new Function<URI, URL>(){

            @Override
            public URL apply(URI uri) {
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }));
    }
}

