/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.api;

import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.Metadata;
import java.util.List;
import java.util.Map;

public interface ServiceRegistrar<MetadataKeyType extends Enum<MetadataKeyType>> {
    default public Uni<Void> registerServiceInstance(String serviceName, String ipAddress, int defaultPort) {
        this.checkAddressNotNull(ipAddress);
        return this.registerServiceInstance(serviceName, Metadata.empty(), ipAddress, defaultPort);
    }

    default public void checkAddressNotNull(String ipAddress) {
        if (ipAddress == null || ipAddress.isEmpty() || ipAddress.isBlank()) {
            throw new IllegalArgumentException("Parameter ipAddress should be provided.");
        }
    }

    default public void checkRegistrarOptionsNotNull(RegistrarOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter registrar options should be provided.");
        }
    }

    public Uni<Void> registerServiceInstance(String var1, Metadata<MetadataKeyType> var2, String var3, int var4);

    default public Uni<Void> registerServiceInstance(RegistrarOptions options) {
        this.checkRegistrarOptionsNotNull(options);
        this.checkAddressNotNull(options.ipAddress());
        return this.registerServiceInstance(options.serviceName(), options.ipAddress(), options.defaultPort());
    }

    public Uni<Void> deregisterServiceInstance(String var1);

    public record RegistrarOptions(String serviceName, String ipAddress, int defaultPort, List<String> tags, Map<String, String> metadata) {
    }
}

