/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.TreeMap;
import java.util.function.Consumer;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinitionRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class RemoteCacheContainerResourceTransformer
implements Consumer<ModelVersion> {
    private final ResourceTransformationDescriptionBuilder builder;

    public RemoteCacheContainerResourceTransformer(ResourceTransformationDescriptionBuilder parent) {
        this.builder = parent.addChildResource(RemoteCacheContainerResourceDefinitionRegistrar.REGISTRATION.getPathElement());
    }

    @Override
    public void accept(ModelVersion version) {
        final TreeMap<String, String> legacyModules = new TreeMap<String, String>();
        if (InfinispanSubsystemModel.VERSION_20_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)this.builder.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{RemoteCacheContainerResourceDefinitionRegistrar.PROTOCOL_VERSION})).setValueConverter(new AttributeConverter(){

                public void convertOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
                    this.convert(attributeValue);
                }

                public void convertResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    this.convert(attributeValue);
                }

                private void convert(ModelNode attributeValue) {
                    if (attributeValue.isDefined()) {
                        attributeValue.set((int)attributeValue.asLong());
                    }
                }
            }, new AttributeDefinition[]{RemoteCacheContainerResourceDefinitionRegistrar.CONNECTION_TIMEOUT, RemoteCacheContainerResourceDefinitionRegistrar.SOCKET_TIMEOUT})).end();
        }
        if (InfinispanSubsystemModel.VERSION_18_0_0.requiresTransformation(version)) {
            legacyModules.put("org.wildfly.clustering.session.infinispan.remote", "org.wildfly.clustering.web.hotrod");
        }
        if (InfinispanSubsystemModel.VERSION_15_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)this.builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{RemoteCacheContainerResourceDefinitionRegistrar.TRANSACTION_TIMEOUT})).setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{RemoteCacheContainerResourceDefinitionRegistrar.MARSHALLER})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleAcceptAttributeChecker(RemoteCacheContainerResourceDefinitionRegistrar.MARSHALLER.getDefaultValue()), new AttributeDefinition[]{RemoteCacheContainerResourceDefinitionRegistrar.MARSHALLER})).end();
        }
        if (!legacyModules.isEmpty()) {
            ((AttributeTransformationDescriptionBuilder)this.builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

                protected void convertAttribute(PathAddress address, String name, ModelNode modules, TransformationContext context) {
                    if (modules.isDefined()) {
                        for (ModelNode module : modules.asList()) {
                            String legacyModule = (String)legacyModules.get(module.asString());
                            if (legacyModule == null) continue;
                            module.set(legacyModule);
                        }
                    }
                }
            }, new AttributeDefinition[]{RemoteCacheContainerResourceDefinitionRegistrar.MODULES})).end();
        }
    }
}

