/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.BinaryServiceDescriptorFactory;
import org.jboss.as.clustering.infinispan.subsystem.ConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceRegistration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.resource.AttributeDefinitionProvider;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public class TableResourceDefinitionRegistrar
extends ConfigurationResourceDefinitionRegistrar<TableManipulationConfiguration, JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder> {
    static final ResourceRegistration REGISTRATION = ResourceRegistration.of((PathElement)PathElement.pathElement((String)"table", (String)"string"));
    static final BinaryServiceDescriptor<TableManipulationConfiguration> SERVICE_DESCRIPTOR = BinaryServiceDescriptorFactory.createServiceDescriptor(List.of(StoreResourceRegistration.WILDCARD, REGISTRATION), TableManipulationConfiguration.class);
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GREATGRANDPARENT_GRANDPARENT).setAllowMultipleRegistrations(true).build();

    TableResourceDefinitionRegistrar() {
        super(new ConfigurationResourceDefinitionRegistrar.Configurator<TableManipulationConfiguration>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return REGISTRATION;
            }

            @Override
            public RuntimeCapability<Void> getCapability() {
                return CAPABILITY;
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).provideAttributes(EnumSet.allOf(Attribute.class))).provideAttributes(EnumSet.allOf(ColumnAttribute.class));
    }

    public ServiceDependency<JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final EnumMap<ColumnAttribute, Map.Entry<String, String>> columns = new EnumMap<ColumnAttribute, Map.Entry<String, String>>(ColumnAttribute.class);
        for (ColumnAttribute column : EnumSet.allOf(ColumnAttribute.class)) {
            ModelNode columnModel = column.resolveModelAttribute((ExpressionResolver)context, model);
            String name = column.getColumnName().resolveModelAttribute(context, columnModel).asString();
            String type = column.getColumnType().resolveModelAttribute(context, columnModel).asString();
            columns.put(column, Map.entry(name, type));
        }
        final int fetchSize = Attribute.FETCH_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final String prefix = Attribute.PREFIX.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final boolean createOnStart = Attribute.CREATE_ON_START.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean dropOnStop = Attribute.DROP_ON_STOP.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        return ServiceDependency.from((Supplier)new Supplier<JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder>(){

            @Override
            public JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder get() {
                return (JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).table().createOnStart(createOnStart)).dropOnExit(dropOnStop)).idColumnName((String)((Map.Entry)columns.get((Object)ColumnAttribute.ID)).getKey())).idColumnType((String)((Map.Entry)columns.get((Object)ColumnAttribute.ID)).getValue())).dataColumnName((String)((Map.Entry)columns.get((Object)ColumnAttribute.DATA)).getKey())).dataColumnType((String)((Map.Entry)columns.get((Object)ColumnAttribute.DATA)).getValue())).segmentColumnName((String)((Map.Entry)columns.get((Object)ColumnAttribute.SEGMENT)).getKey())).segmentColumnType((String)((Map.Entry)columns.get((Object)ColumnAttribute.SEGMENT)).getValue())).timestampColumnName((String)((Map.Entry)columns.get((Object)ColumnAttribute.TIMESTAMP)).getKey())).timestampColumnType((String)((Map.Entry)columns.get((Object)ColumnAttribute.TIMESTAMP)).getValue())).fetchSize(fetchSize)).tableNamePrefix(prefix);
            }
        });
    }

    static enum Attribute implements AttributeDefinitionProvider
    {
        PREFIX("prefix", ModelType.STRING, new ModelNode("ispn_entry")),
        FETCH_SIZE("fetch-size", ModelType.INT, new ModelNode(100)),
        CREATE_ON_START("create-on-start", ModelType.BOOLEAN, ModelNode.TRUE),
        DROP_ON_STOP("drop-on-stop", ModelType.BOOLEAN, ModelNode.FALSE);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition get() {
            return this.definition;
        }
    }

    static enum ColumnAttribute implements AttributeDefinitionProvider
    {
        ID("id-column", "id", "VARCHAR"),
        DATA("data-column", "datum", "BINARY"),
        SEGMENT("segment-column", "segment", "INTEGER"),
        TIMESTAMP("timestamp-column", "version", "BIGINT");

        private final AttributeDefinition name;
        private final AttributeDefinition type;
        private final AttributeDefinition definition;

        private ColumnAttribute(String name, String defaultName, String defaultType) {
            this.name = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode(defaultName))).build();
            this.type = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode(defaultType))).build();
            this.definition = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)name, (AttributeDefinition[])new AttributeDefinition[]{this.name, this.type}).setRequired(false)).setSuffix("column").build();
        }

        AttributeDefinition getColumnName() {
            return this.name;
        }

        AttributeDefinition getColumnType() {
            return this.type;
        }

        public AttributeDefinition get() {
            return this.definition;
        }
    }
}

