/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.rts.service;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import jakarta.servlet.ServletException;
import java.net.Inet4Address;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.network.SocketBinding;
import org.jboss.jbossts.star.service.ContextListener;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.wildfly.extension.rts.logging.RTSLogger;
import org.wildfly.extension.rts.service.ParticipantService;
import org.wildfly.extension.undertow.Host;

public class AbstractRTSService {
    private final Supplier<Host> hostSupplier;
    private final Supplier<SocketBinding> socketBindingSupplier;
    private volatile Deployment deployment = null;

    public AbstractRTSService(Supplier<Host> hostSupplier, Supplier<SocketBinding> socketBindingSupplier) {
        this.hostSupplier = hostSupplier;
        this.socketBindingSupplier = socketBindingSupplier;
    }

    protected DeploymentInfo getDeploymentInfo(String name, String contextPath, Map<String, String> initialParameters) {
        DeploymentInfo deploymentInfo = new DeploymentInfo();
        deploymentInfo.setClassLoader(ParticipantService.class.getClassLoader());
        deploymentInfo.setContextPath(contextPath);
        deploymentInfo.setDeploymentName(name);
        deploymentInfo.addServlets(new ServletInfo[]{this.getResteasyServlet()});
        deploymentInfo.addListener(this.getRestATListener());
        for (Map.Entry<String, String> entry : initialParameters.entrySet()) {
            deploymentInfo.addInitParameter(entry.getKey(), entry.getValue());
        }
        return deploymentInfo;
    }

    protected void deployServlet(DeploymentInfo deploymentInfo) {
        DeploymentManager manager = ServletContainer.Factory.newInstance().addDeployment(deploymentInfo);
        manager.deploy();
        this.deployment = manager.getDeployment();
        try {
            this.hostSupplier.get().registerDeployment(this.deployment, manager.start());
        }
        catch (ServletException e) {
            RTSLogger.ROOT_LOGGER.warn(e.getMessage(), e);
            this.deployment = null;
        }
    }

    protected void undeployServlet() {
        if (this.deployment != null) {
            this.hostSupplier.get().unregisterDeployment(this.deployment);
            this.deployment = null;
        }
    }

    protected String getBaseUrl() {
        String address = this.socketBindingSupplier.get().getAddress().getHostAddress();
        int port = this.socketBindingSupplier.get().getAbsolutePort();
        if (this.socketBindingSupplier.get().getAddress() instanceof Inet4Address) {
            return "http://" + address + ":" + port;
        }
        return "http://[" + address + "]:" + port;
    }

    private ServletInfo getResteasyServlet() {
        ServletInfo servletInfo = new ServletInfo("Resteasy", HttpServletDispatcher.class);
        servletInfo.addMapping("/*");
        return servletInfo;
    }

    private ListenerInfo getRestATListener() {
        ListenerInfo listenerInfo = new ListenerInfo(ContextListener.class);
        return listenerInfo;
    }
}

