/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.metacommand.ExploreNodeAction;

public class TabsMenu
extends JMenu {
    private CliGuiContext cliGuiCtx;

    public TabsMenu(CliGuiContext cliGuiCtx) {
        super("Tabs");
        this.cliGuiCtx = cliGuiCtx;
        this.setMnemonic(84);
        this.addMenuListener(new TabsMenuListener());
    }

    private class TabsMenuListener
    implements MenuListener {
        private TabsMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            TabsMenu.this.removeAll();
            ExploreNodeAction exploreAction = new ExploreNodeAction(TabsMenu.this.cliGuiCtx);
            JMenuItem exploreSelectedNode = new JMenuItem(exploreAction);
            exploreSelectedNode.setMnemonic(69);
            if (exploreAction.getSelectedNode() == null || exploreAction.getSelectedNode().isLeaf()) {
                exploreSelectedNode.setEnabled(false);
            }
            TabsMenu.this.add(exploreSelectedNode);
            TabsMenu.this.addSeparator();
            JTabbedPane tabs = TabsMenu.this.cliGuiCtx.getTabs();
            for (int i = 0; i < tabs.getTabCount(); ++i) {
                GoToTabAction action = new GoToTabAction(i, tabs.getTitleAt(i));
                JMenuItem item = new JMenuItem(action);
                item.setToolTipText(tabs.getToolTipTextAt(i));
                TabsMenu.this.add(item);
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }

    private class GoToTabAction
    extends AbstractAction {
        private int index;

        public GoToTabAction(int index, String title) {
            super(title);
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabsMenu.this.cliGuiCtx.getTabs().setSelectedIndex(this.index);
        }
    }
}

