/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.staticlist;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StaticConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public StaticConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public StaticConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "static";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private StaticConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new StaticConfiguration(copy);
    }

    public String getAddressList() {
        return this.parameters.get("address-list");
    }

    public StaticConfiguration withAddressList(String value) {
        return this.extend("address-list", value);
    }

    public String getSecure() {
        return this.parameters.get("secure");
    }

    public StaticConfiguration withSecure(String value) {
        return this.extend("secure", value);
    }

    public String getShuffle() {
        String result = this.parameters.get("shuffle");
        return result == null ? "false" : result;
    }

    public StaticConfiguration withShuffle(String value) {
        return this.extend("shuffle", value);
    }
}

