/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.ChildDocIds;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;

public abstract class JoiningLongMultiValuesSource
extends LongMultiValuesSource {
    protected final NestedDocsProvider nestedDocsProvider;

    public static JoiningLongMultiValuesSource fromLongField(String field, NestedDocsProvider nested) {
        return JoiningLongMultiValuesSource.fromField(field, nested);
    }

    public static JoiningLongMultiValuesSource fromIntField(String field, NestedDocsProvider nested) {
        return JoiningLongMultiValuesSource.fromField(field, nested);
    }

    private static JoiningLongMultiValuesSource fromField(String field, NestedDocsProvider nested) {
        return new FieldLongMultiValuesSource(field, nested);
    }

    public JoiningLongMultiValuesSource(NestedDocsProvider nestedDocsProvider) {
        this.nestedDocsProvider = nestedDocsProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoiningLongMultiValuesSource that = (JoiningLongMultiValuesSource)o;
        return Objects.equals(this.nestedDocsProvider, that.nestedDocsProvider);
    }

    public int hashCode() {
        return this.nestedDocsProvider.hashCode();
    }

    @Override
    public LongMultiValues getValues(LeafReaderContext ctx) throws IOException {
        SortedNumericDocValues values = this.getSortedNumericDocValues(ctx);
        if (this.nestedDocsProvider == null) {
            return LongMultiValues.fromDocValues(values);
        }
        return this.select(values, this.nestedDocsProvider.childDocs(ctx, (DocIdSetIterator)values));
    }

    protected abstract SortedNumericDocValues getSortedNumericDocValues(LeafReaderContext var1) throws IOException;

    protected LongMultiValues select(SortedNumericDocValues values, final ChildDocIds childDocsWithValues) {
        if (childDocsWithValues == null) {
            return LongMultiValues.EMPTY;
        }
        return new LongMultiValues.DocValuesLongMultiValues(values){
            private int currentParentDoc;
            {
                super(values);
                this.currentParentDoc = -1;
            }

            @Override
            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.currentParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.currentParentDoc) {
                    return this.hasNextValue();
                }
                this.currentParentDoc = parentDoc;
                boolean found = childDocsWithValues.advanceExactParent(parentDoc);
                if (found) {
                    childDocsWithValues.nextChild();
                }
                this.updateRemaining(found);
                return found;
            }

            @Override
            public boolean hasNextValue() throws IOException {
                if (super.hasNextValue()) {
                    return true;
                }
                boolean hasNextChildDocWithValue = childDocsWithValues.nextChild() != Integer.MAX_VALUE;
                this.updateRemaining(hasNextChildDocWithValue);
                return hasNextChildDocWithValue;
            }
        };
    }

    private static class FieldLongMultiValuesSource
    extends JoiningLongMultiValuesSource {
        private final String field;

        public FieldLongMultiValuesSource(String field, NestedDocsProvider nestedDocsProvider) {
            super(nestedDocsProvider);
            this.field = field;
        }

        public String toString() {
            return "Long(" + this.field + "," + String.valueOf(this.nestedDocsProvider) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            FieldLongMultiValuesSource that = (FieldLongMultiValuesSource)o;
            return Objects.equals(this.field, that.field);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.field);
        }

        @Override
        protected SortedNumericDocValues getSortedNumericDocValues(LeafReaderContext ctx) throws IOException {
            return DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.field);
        }
    }
}

