/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.infinispan.AbstractCacheEntryMutator;

public class RemoteCacheEntryMutator<K, V>
extends AbstractCacheEntryMutator {
    private final RemoteCache<K, V> cache;
    private final K key;
    private final V value;

    RemoteCacheEntryMutator(RemoteCache<K, V> cache, K key, V value) {
        this.cache = cache;
        this.key = key;
        this.value = value;
    }

    public CompletionStage<Void> runAsync() {
        Duration maxIdleDuration = this.get();
        long seconds = maxIdleDuration.getSeconds();
        int nanos = maxIdleDuration.getNano();
        if (nanos > 0) {
            ++seconds;
        }
        return this.cache.putAsync(this.key, this.value, 0L, TimeUnit.SECONDS, seconds, TimeUnit.SECONDS).thenAccept((Consumer)org.wildfly.clustering.function.Consumer.empty());
    }
}

