/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.SessionManagerFactory;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.web.session.SharedSessionManagerConfig;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.container.WebDeploymentConfiguration;
import org.wildfly.clustering.web.container.WebDeploymentServiceInstallerProvider;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.deployment.DefaultDeploymentMappingProvider;
import org.wildfly.extension.undertow.deployment.ImmediateSessionManagerFactory;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;
import org.wildfly.extension.undertow.session.NonDistributableWebDeploymentServiceInstallerProvider;

public class SharedSessionManagerDeploymentProcessor
implements DeploymentUnitProcessor {
    private final String defaultServerName;
    private final Optional<WebDeploymentServiceInstallerProvider> distributableServiceInstallerProvider;
    private final NonDistributableWebDeploymentServiceInstallerProvider nonDistributableServiceInstallerProvider;

    public SharedSessionManagerDeploymentProcessor(String defaultServerName) {
        this.defaultServerName = defaultServerName;
        this.nonDistributableServiceInstallerProvider = new NonDistributableWebDeploymentServiceInstallerProvider(new Function<SessionManagerFactoryConfiguration, SessionManagerFactory>(){

            @Override
            public SessionManagerFactory apply(SessionManagerFactoryConfiguration configuration) {
                String deploymentName = configuration.getDeploymentName();
                OptionalInt maxActiveSessions = configuration.getMaxActiveSessions();
                InMemorySessionManager manager = maxActiveSessions.isPresent() ? new InMemorySessionManager(deploymentName, maxActiveSessions.getAsInt()) : new InMemorySessionManager(deploymentName);
                manager.setDefaultSessionTimeout((int)configuration.getDefaultSessionTimeout().getSeconds());
                return new ImmediateSessionManagerFactory((SessionManager)manager);
            }
        });
        this.distributableServiceInstallerProvider = ServiceLoader.load(WebDeploymentServiceInstallerProvider.class, WebDeploymentServiceInstallerProvider.class.getClassLoader()).findFirst();
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        final DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        final SharedSessionManagerConfig sharedConfig = (SharedSessionManagerConfig)deploymentUnit.getAttachment(SharedSessionManagerConfig.ATTACHMENT_KEY);
        if (sharedConfig == null) {
            return;
        }
        final String deploymentName = deploymentUnit.getParent() == null ? deploymentUnit.getName() : String.join((CharSequence)".", deploymentUnit.getParent().getName(), deploymentUnit.getName());
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        final String serverName = Optional.ofNullable(warMetaData).map(metaData -> metaData.getMergedJBossWebMetaData().getServerInstanceName()).orElse(Optional.ofNullable(DefaultDeploymentMappingProvider.instance().getMapping(deploymentName)).map(Map.Entry::getKey).orElse(this.defaultServerName));
        SessionConfigMetaData sessionConfig = sharedConfig.getSessionConfig();
        ServletContainerService servletContainer = (ServletContainerService)deploymentUnit.getAttachment(UndertowAttachments.SERVLET_CONTAINER_SERVICE);
        final Integer defaultSessionTimeout = sessionConfig != null && sessionConfig.getSessionTimeoutSet() ? sessionConfig.getSessionTimeout() : (servletContainer != null ? servletContainer.getDefaultSessionTimeout() : Integer.valueOf(30).intValue());
        NonDistributableWebDeploymentServiceInstallerProvider provider = sharedConfig.isDistributable() ? this.distributableServiceInstallerProvider.orElseGet(this.nonDistributableServiceInstallerProvider) : this.nonDistributableServiceInstallerProvider;
        SessionManagerFactoryConfiguration configuration = new SessionManagerFactoryConfiguration(){

            public String getServerName() {
                return serverName;
            }

            public String getDeploymentName() {
                return deploymentName;
            }

            public OptionalInt getMaxActiveSessions() {
                Integer maxActiveSessions = sharedConfig.getMaxActiveSessions();
                return maxActiveSessions != null && maxActiveSessions > 0 ? OptionalInt.of(maxActiveSessions) : OptionalInt.empty();
            }

            public DeploymentUnit getDeploymentUnit() {
                return deploymentUnit;
            }

            public Duration getDefaultSessionTimeout() {
                return Duration.ofMinutes(defaultSessionTimeout.intValue());
            }
        };
        provider.getSessionManagerFactoryServiceInstaller(configuration).install(phaseContext);
        provider.getSessionAffinityProviderServiceInstaller((WebDeploymentConfiguration)configuration).install(phaseContext);
    }
}

