/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.JSPConfig;
import org.wildfly.extension.undertow.ServletContainerAdd;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowExtension;

class JspDefinition
extends PersistentResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"setting", (String)"jsp");
    protected static final SimpleAttributeDefinition DEVELOPMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("development", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition DISABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("disabled", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition KEEP_GENERATED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("keep-generated", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition TRIM_SPACES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("trim-spaces", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition TAG_POOLING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("tag-pooling", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition MAPPED_FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("mapped-file", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition CHECK_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("check-interval", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.ZERO)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition MODIFICATION_TEST_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("modification-test-interval", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(4))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition RECOMPILE_ON_FAIL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("recompile-on-fail", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition SMAP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("smap", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition DUMP_SMAP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("dump-smap", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition GENERATE_STRINGS_AS_CHAR_ARRAYS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("generate-strings-as-char-arrays", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("error-on-use-bean-invalid-class-attribute", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition SCRATCH_DIR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scratch-dir", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition SOURCE_VM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("source-vm", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setDefaultValue(new ModelNode("1.8"))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition TARGET_VM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("target-vm", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setDefaultValue(new ModelNode("1.8"))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition JAVA_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("java-encoding", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setDefaultValue(new ModelNode("UTF8"))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition X_POWERED_BY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("x-powered-by", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true))).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition DISPLAY_SOURCE_FRAGMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("display-source-fragment", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true))).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition OPTIMIZE_SCRIPTLETS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("optimize-scriptlets", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true))).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = List.of(DISABLED, DEVELOPMENT, KEEP_GENERATED, TRIM_SPACES, TAG_POOLING, MAPPED_FILE, CHECK_INTERVAL, MODIFICATION_TEST_INTERVAL, RECOMPILE_ON_FAIL, SMAP, DUMP_SMAP, GENERATE_STRINGS_AS_CHAR_ARRAYS, ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUTE, SCRATCH_DIR, SOURCE_VM, TARGET_VM, JAVA_ENCODING, X_POWERED_BY, DISPLAY_SOURCE_FRAGMENT, OPTIMIZE_SCRIPTLETS);

    JspDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, (ResourceDescriptionResolver)UndertowExtension.getResolver(PATH_ELEMENT.getKeyValuePair())).setAddHandler((OperationStepHandler)new JSPAdd()).setRemoveHandler((OperationStepHandler)new JSPRemove()));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static JSPConfig getConfig(ExpressionResolver context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return null;
        }
        boolean disabled = DISABLED.resolveModelAttribute(context, model).asBoolean();
        boolean development = DEVELOPMENT.resolveModelAttribute(context, model).asBoolean();
        boolean keepGenerated = KEEP_GENERATED.resolveModelAttribute(context, model).asBoolean();
        boolean trimSpaces = TRIM_SPACES.resolveModelAttribute(context, model).asBoolean();
        boolean tagPooling = TAG_POOLING.resolveModelAttribute(context, model).asBoolean();
        boolean mappedFile = MAPPED_FILE.resolveModelAttribute(context, model).asBoolean();
        int checkInterval = CHECK_INTERVAL.resolveModelAttribute(context, model).asInt();
        int modificationTestInterval = MODIFICATION_TEST_INTERVAL.resolveModelAttribute(context, model).asInt();
        boolean recompileOnFile = RECOMPILE_ON_FAIL.resolveModelAttribute(context, model).asBoolean();
        boolean snap = SMAP.resolveModelAttribute(context, model).asBoolean();
        boolean dumpSnap = DUMP_SMAP.resolveModelAttribute(context, model).asBoolean();
        boolean generateStringsAsCharArrays = GENERATE_STRINGS_AS_CHAR_ARRAYS.resolveModelAttribute(context, model).asBoolean();
        boolean errorOnUseBeanInvalidClassAttribute = ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUTE.resolveModelAttribute(context, model).asBoolean();
        ModelNode scratchDirValue = SCRATCH_DIR.resolveModelAttribute(context, model);
        String scratchDir = scratchDirValue.isDefined() ? scratchDirValue.asString() : null;
        String sourceVm = SOURCE_VM.resolveModelAttribute(context, model).asString();
        String targetVm = TARGET_VM.resolveModelAttribute(context, model).asString();
        String javaEncoding = JAVA_ENCODING.resolveModelAttribute(context, model).asString();
        boolean xPoweredBy = X_POWERED_BY.resolveModelAttribute(context, model).asBoolean();
        boolean displaySourceFragment = DISPLAY_SOURCE_FRAGMENT.resolveModelAttribute(context, model).asBoolean();
        boolean optimizeScriptlets = OPTIMIZE_SCRIPTLETS.resolveModelAttribute(context, model).asBoolean();
        return new JSPConfig(development, disabled, keepGenerated, trimSpaces, tagPooling, mappedFile, checkInterval, modificationTestInterval, recompileOnFile, snap, dumpSnap, generateStringsAsCharArrays, errorOnUseBeanInvalidClassAttribute, scratchDir, sourceVm, targetVm, javaEncoding, xPoweredBy, displaySourceFragment, optimizeScriptlets);
    }

    private static class JSPAdd
    extends RestartParentResourceAddHandler {
        protected JSPAdd() {
            super(ServletContainerDefinition.PATH_ELEMENT.getKey());
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition def : ATTRIBUTES) {
                def.validateAndSet(operation, model);
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.installRuntimeServices(context.getCapabilityServiceTarget(), (ExpressionResolver)context, parentAddress, parentModel);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ServletContainerDefinition.SERVLET_CONTAINER_CAPABILITY.getCapabilityServiceName(parentAddress);
        }
    }

    private static class JSPRemove
    extends RestartParentResourceRemoveHandler {
        protected JSPRemove() {
            super(ServletContainerDefinition.PATH_ELEMENT.getKey());
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ServletContainerAdd.installRuntimeServices(context.getCapabilityServiceTarget(), (ExpressionResolver)context, parentAddress, parentModel);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ServletContainerDefinition.SERVLET_CONTAINER_CAPABILITY.getCapabilityServiceName(parentAddress);
        }
    }
}

