/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.as.controller.access.constraint.HostEffectConstraint;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.HostScopedRolesResourceDefinition;
import org.jboss.as.domain.management.access.ScopedRoleAddHandler;
import org.jboss.dmr.ModelNode;

class HostScopedRoleAdd
extends ScopedRoleAddHandler {
    private final Map<String, HostEffectConstraint> constraintMap;
    private final WritableAuthorizerConfiguration authorizerConfiguration;

    HostScopedRoleAdd(Map<String, HostEffectConstraint> constraintMap, WritableAuthorizerConfiguration authorizerConfiguration) {
        super(authorizerConfiguration);
        this.constraintMap = constraintMap;
        this.authorizerConfiguration = authorizerConfiguration;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String roleName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String baseRole = HostScopedRolesResourceDefinition.BASE_ROLE.resolveModelAttribute(context, model).asString();
        ModelNode hostsAttribute = HostScopedRolesResourceDefinition.HOSTS.resolveModelAttribute(context, model);
        List nodeList = hostsAttribute.isDefined() ? hostsAttribute.asList() : Collections.emptyList();
        HostScopedRoleAdd.addScopedRole(roleName, baseRole, nodeList, this.authorizerConfiguration, this.constraintMap);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        String roleName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        this.authorizerConfiguration.removeScopedRole(roleName);
        this.constraintMap.remove(roleName);
    }

    static void addScopedRole(String roleName, String baseRole, List<ModelNode> hostNodes, WritableAuthorizerConfiguration authorizerConfiguration, Map<String, HostEffectConstraint> constraintMap) {
        ArrayList<String> hosts = new ArrayList<String>();
        for (ModelNode host : hostNodes) {
            hosts.add(host.asString());
        }
        HostEffectConstraint constraint = new HostEffectConstraint(hosts);
        authorizerConfiguration.addScopedRole(new AuthorizerConfiguration.ScopedRole(roleName, baseRole, (ScopingConstraint)constraint));
        constraintMap.put(roleName, constraint);
    }
}

