/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.service;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.ee.concurrent.ConcurrencyImplementation;
import org.jboss.as.ee.concurrent.WildFlyContextService;
import org.jboss.as.ee.concurrent.WildFlyManagedThreadFactory;
import org.jboss.as.ee.concurrent.service.DelegatingSupplier;
import org.jboss.as.ee.concurrent.service.EEConcurrentAbstractService;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ManagedThreadFactoryService
extends EEConcurrentAbstractService<WildFlyManagedThreadFactory> {
    private volatile WildFlyManagedThreadFactory managedThreadFactory;
    private final Consumer<WildFlyManagedThreadFactory> consumer;
    private final String name;
    private final DelegatingSupplier<WildFlyContextService> contextServiceSupplier = new DelegatingSupplier();
    private final int priority;

    public ManagedThreadFactoryService(Consumer<WildFlyManagedThreadFactory> consumer, Supplier<WildFlyContextService> ctxServiceSupplier, String name, String jndiName, int priority) {
        super(jndiName);
        this.consumer = consumer;
        this.name = name;
        this.contextServiceSupplier.set(ctxServiceSupplier);
        this.priority = priority;
    }

    @Override
    void startValue(StartContext context) throws StartException {
        String threadFactoryName = "EE-ManagedThreadFactory-" + this.name;
        this.managedThreadFactory = ConcurrencyImplementation.INSTANCE.newManagedThreadFactory(threadFactoryName, this.contextServiceSupplier.get(), this.priority);
        this.consumer.accept(this.managedThreadFactory);
    }

    @Override
    void stopValue(StopContext context) {
        this.managedThreadFactory.stop();
        this.managedThreadFactory = null;
        this.consumer.accept(null);
    }

    public WildFlyManagedThreadFactory getValue() throws IllegalStateException {
        if (this.managedThreadFactory == null) {
            throw EeLogger.ROOT_LOGGER.concurrentServiceValueUninitialized();
        }
        return this.managedThreadFactory;
    }

    public DelegatingSupplier<WildFlyContextService> getContextServiceSupplier() {
        return this.contextServiceSupplier;
    }
}

