/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.requestcontroller.RunResult;

public class ControlPoint {
    private static final AtomicIntegerFieldUpdater<ControlPoint> activeRequestCountUpdater = AtomicIntegerFieldUpdater.newUpdater(ControlPoint.class, "activeRequestCount");
    private static final AtomicReferenceFieldUpdater<ControlPoint, CompletableFuture> pauseUpdater = AtomicReferenceFieldUpdater.newUpdater(ControlPoint.class, CompletableFuture.class, "pauseFuture");
    private final RequestController controller;
    private final String deployment;
    private final String entryPoint;
    private final boolean trackIndividualControlPoints;
    private volatile int activeRequestCount = 0;
    private volatile boolean paused = false;
    private volatile CompletableFuture<Void> pauseFuture = null;
    private int referenceCount = 0;

    ControlPoint(RequestController controller, String deployment, String entryPoint, boolean trackIndividualControlPoints) {
        this.controller = controller;
        this.deployment = deployment;
        this.entryPoint = entryPoint;
        this.trackIndividualControlPoints = trackIndividualControlPoints;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public CompletionStage<Void> pause() {
        if (this.paused) {
            throw ServerLogger.ROOT_LOGGER.serverAlreadyPaused();
        }
        this.paused = true;
        CompletableFuture<Void> pause = new CompletableFuture<Void>();
        pauseUpdater.set(this, pause);
        if (activeRequestCountUpdater.get(this) == 0 && pauseUpdater.compareAndSet(this, pause, null)) {
            pause.complete(null);
        }
        return pause;
    }

    @Deprecated(forRemoval=true)
    public void pause(ServerActivityCallback requestCountListener) {
        this.pause().whenComplete((ignore, exception) -> requestCountListener.done());
    }

    public void resume() {
        this.paused = false;
        CompletableFuture pause = pauseUpdater.get(this);
        if (pause != null) {
            pauseUpdater.compareAndSet(this, pause, null);
            pause.cancel(false);
        }
    }

    public RunResult beginRequest() {
        RunResult runResult;
        if (this.paused) {
            return RunResult.REJECTED;
        }
        if (this.trackIndividualControlPoints) {
            activeRequestCountUpdater.incrementAndGet(this);
        }
        if ((runResult = this.controller.beginRequest(false)) == RunResult.REJECTED) {
            this.decreaseRequestCount();
        }
        return runResult;
    }

    public RunResult forceBeginRequest() {
        if (this.trackIndividualControlPoints) {
            activeRequestCountUpdater.incrementAndGet(this);
        }
        return this.controller.beginRequest(true);
    }

    void beginExistingRequest() {
        if (this.trackIndividualControlPoints) {
            activeRequestCountUpdater.incrementAndGet(this);
        }
    }

    public void requestComplete() {
        this.decreaseRequestCount();
        this.controller.requestComplete();
    }

    private void decreaseRequestCount() {
        if (this.trackIndividualControlPoints) {
            CompletableFuture pause;
            int result = activeRequestCountUpdater.decrementAndGet(this);
            if (this.paused && result == 0 && (pause = pauseUpdater.get(this)) != null && pauseUpdater.compareAndSet(this, pause, null)) {
                pause.complete(null);
            }
        }
    }

    public void queueTask(Runnable task, Executor taskExecutor, long timeout, Runnable timeoutTask, boolean rejectOnSuspend) {
        this.controller.queueTask(this, task, taskExecutor, timeout, timeoutTask, rejectOnSuspend, false);
    }

    public void forceQueueTask(Runnable task, Executor taskExecutor) {
        this.controller.queueTask(this, task, taskExecutor, -1L, null, false, true);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getActiveRequestCount() {
        return activeRequestCountUpdater.get(this);
    }

    synchronized int increaseReferenceCount() {
        return ++this.referenceCount;
    }

    synchronized int decreaseReferenceCount() {
        return --this.referenceCount;
    }
}

