/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.Query;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.spi.ConditionalExpression;

public abstract class ConditionalExpressionQueryFactory<E, I>
implements TypeQueryFactory<E, I> {
    private static final String TYPES_PARAM_NAME = "HIBERNATE_SEARCH_INCLUDED_TYPES_FILTER";
    protected final Class<I> uniquePropertyType;
    protected final String uniquePropertyName;
    private final boolean uniquePropertyIsTheEntityId;

    public ConditionalExpressionQueryFactory(Class<I> uniquePropertyType, String uniquePropertyName, boolean uniquePropertyIsTheEntityId) {
        this.uniquePropertyType = uniquePropertyType;
        this.uniquePropertyName = uniquePropertyName;
        this.uniquePropertyIsTheEntityId = uniquePropertyIsTheEntityId;
    }

    @Override
    public final boolean uniquePropertyIsTheEntityId() {
        return this.uniquePropertyIsTheEntityId;
    }

    @Override
    public Query<Long> createQueryForCount(SharedSessionContractImplementor session, EntityDomainType<?> entityDomainType, Set<? extends Class<? extends E>> includedTypesFilter, List<ConditionalExpression> conditionalExpressions) {
        return this.createQueryWithConditionalExpressionsOrOrder(session, "select count(e) from " + entityDomainType.getName() + " e", Long.class, "e", includedTypesFilter, conditionalExpressions, null);
    }

    @Override
    public Query<I> createQueryForIdentifierListing(SharedSessionContractImplementor session, EntityDomainType<?> entityDomainType, Set<? extends Class<? extends E>> includedTypesFilter, List<ConditionalExpression> conditionalExpressions, String order) {
        return this.createQueryWithConditionalExpressionsOrOrder(session, "select e." + this.uniquePropertyName + " from " + entityDomainType.getName() + " e", this.uniquePropertyType, "e", includedTypesFilter, conditionalExpressions, order);
    }

    private <T> Query<T> createQueryWithConditionalExpressionsOrOrder(SharedSessionContractImplementor session, String hql, Class<T> returnedType, String entityAlias, Set<? extends Class<? extends E>> includedTypesFilter, List<ConditionalExpression> conditionalExpressions, String order) {
        List<ConditionalExpression> allConditionalExpressions;
        if (!includedTypesFilter.isEmpty()) {
            ConditionalExpression typeFilter = new ConditionalExpression("type(" + entityAlias + ") in (:HIBERNATE_SEARCH_INCLUDED_TYPES_FILTER)");
            typeFilter.param(TYPES_PARAM_NAME, includedTypesFilter);
            allConditionalExpressions = new ArrayList<ConditionalExpression>();
            allConditionalExpressions.add(typeFilter);
            allConditionalExpressions.addAll(conditionalExpressions);
        } else {
            allConditionalExpressions = conditionalExpressions;
        }
        return this.createQueryWithConditionalExpressionsOrOrder(session, hql, returnedType, allConditionalExpressions, order);
    }

    private <T> Query<T> createQueryWithConditionalExpressionsOrOrder(SharedSessionContractImplementor session, String hql, Class<T> returnedType, List<ConditionalExpression> conditionalExpressions, String order) {
        StringBuilder hqlBuilder = new StringBuilder(hql);
        if (!conditionalExpressions.isEmpty()) {
            hqlBuilder.append(" where ");
            boolean first = true;
            for (ConditionalExpression expression : conditionalExpressions) {
                if (first) {
                    first = false;
                } else {
                    hqlBuilder.append(" and ");
                }
                hqlBuilder.append("(").append(expression.hql()).append(")");
            }
        }
        if (order != null) {
            hqlBuilder.append(" order by ").append(order);
        }
        QueryImplementor query = session.createQuery(hqlBuilder.toString(), returnedType);
        for (ConditionalExpression expression : conditionalExpressions) {
            expression.applyParams((Query<?>)query);
        }
        return query;
    }
}

