/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import java.util.List;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.cache.infinispan.batch.ContextualBatch;
import org.wildfly.clustering.cache.infinispan.batch.ContextualException;
import org.wildfly.clustering.cache.infinispan.batch.ContextualSuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.context.ContextReference;

enum ThreadContextBatch implements Batch,
ContextReference<ContextualBatch>
{
    INSTANCE;

    private static final ThreadLocal<ContextualBatch> THREAD_CONTEXT;
    private static final Batch.Status CLOSED_STATUS;

    public void accept(ContextualBatch batch) {
        if (batch != null) {
            THREAD_CONTEXT.set(batch);
        } else {
            THREAD_CONTEXT.remove();
        }
    }

    public ContextualBatch get() {
        return THREAD_CONTEXT.get();
    }

    public Batch.Status getStatus() {
        ContextualBatch batch = this.get();
        return batch != null ? batch.getStatus() : CLOSED_STATUS;
    }

    public SuspendedBatch suspend() {
        ContextualSuspendedBatch suspended;
        ContextualBatch batch = this.get();
        ContextualSuspendedBatch contextualSuspendedBatch = suspended = batch != null ? batch.suspend() : null;
        if (batch != null) {
            this.accept(null);
        }
        return new SuspendedBatch(){

            public Context<Batch> resumeWithContext() {
                SuspendedBatch suspended2 = ThreadContextBatch.this.suspend();
                Batch resumed = this.resume();
                return Context.of((Object)resumed, (Runnable)org.wildfly.clustering.function.Runnable.runAll(List.of(() -> ((Batch)resumed).suspend(), () -> ((SuspendedBatch)suspended2).resume())));
            }

            public Batch resume() {
                ContextualBatch current = ThreadContextBatch.this.get();
                if (current != null) {
                    throw new IllegalStateException(this.toString(), new ContextualException(current));
                }
                ContextualBatch resumed = suspended != null ? suspended.resume() : null;
                ThreadContextBatch.this.accept(resumed);
                return INSTANCE;
            }
        };
    }

    public void discard() {
        ContextualBatch batch = this.get();
        if (batch != null) {
            batch.discard();
        }
    }

    public void close() {
        ContextualBatch batch = this.get();
        if (batch != null) {
            batch.close();
            if (batch.getStatus().isClosed()) {
                this.accept(null);
            }
        }
    }

    public String toString() {
        ContextualBatch batch = this.get();
        return batch != null ? batch.toString() : "none";
    }

    static {
        THREAD_CONTEXT = new ThreadLocal();
        CLOSED_STATUS = new Batch.Status(){

            public boolean isActive() {
                return false;
            }

            public boolean isDiscarding() {
                return false;
            }

            public boolean isClosed() {
                return true;
            }
        };
    }
}

