/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;

public class AsyncServiceConfigurator
extends SimpleServiceNameProvider
implements ServiceConfigurator {
    private static final ServiceName EXECUTOR_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"as", "server-executor"});
    private volatile boolean asyncStart = true;
    private volatile boolean asyncStop = true;

    public AsyncServiceConfigurator(ServiceName name) {
        super(name);
    }

    @Override
    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Supplier executor = builder.requires(EXECUTOR_SERVICE_NAME);
        return new AsyncServiceBuilder(builder, executor, this.asyncStart, this.asyncStop);
    }

    public AsyncServiceConfigurator startSynchronously() {
        this.asyncStart = false;
        return this;
    }

    public AsyncServiceConfigurator stopSynchronously() {
        this.asyncStop = false;
        return this;
    }

    private static class AsyncServiceBuilder<T>
    extends DelegatingServiceBuilder<T> {
        private final Supplier<Executor> executor;
        private final boolean asyncStart;
        private final boolean asyncStop;

        AsyncServiceBuilder(ServiceBuilder<T> delegate, Supplier<Executor> executor, boolean asyncStart, boolean asyncStop) {
            super(delegate);
            this.executor = executor;
            this.asyncStart = asyncStart;
            this.asyncStop = asyncStop;
        }

        public ServiceBuilder<T> setInstance(Service service) {
            return super.setInstance((Service)new AsyncService(service, this.executor, this.asyncStart, this.asyncStop));
        }
    }

    private static class AsyncService
    implements Service {
        private final Service service;
        private final Supplier<Executor> executor;
        private final boolean asyncStart;
        private final boolean asyncStop;

        AsyncService(Service service, Supplier<Executor> executor, boolean asyncStart, boolean asyncStop) {
            this.service = service;
            this.executor = executor;
            this.asyncStart = asyncStart;
            this.asyncStop = asyncStop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(StartContext context) throws StartException {
            if (this.asyncStart) {
                Runnable task = () -> {
                    try {
                        this.service.start(context);
                        context.complete();
                    }
                    catch (StartException e) {
                        context.failed(e);
                    }
                    catch (Throwable e) {
                        context.failed(new StartException(e));
                    }
                };
                try {
                    this.executor.get().execute(task);
                }
                catch (RejectedExecutionException e) {
                    task.run();
                }
                finally {
                    context.asynchronous();
                }
            } else {
                this.service.start(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(StopContext context) {
            if (this.asyncStop) {
                Runnable task = () -> {
                    try {
                        this.service.stop(context);
                    }
                    finally {
                        context.complete();
                    }
                };
                try {
                    this.executor.get().execute(task);
                }
                catch (RejectedExecutionException e) {
                    task.run();
                }
                finally {
                    context.asynchronous();
                }
            } else {
                this.service.stop(context);
            }
        }
    }
}

