/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.suspend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerResumeContext;
import org.jboss.as.server.suspend.ServerSuspendContext;
import org.jboss.as.server.suspend.ServerSuspendController;
import org.jboss.as.server.suspend.SuspendableActivity;
import org.jboss.as.server.suspend.SuspendableActivityRegistry;
import org.jboss.as.server.suspend.SuspensionStateProvider;
import org.wildfly.common.Assert;

public class SuspendController
implements ServerSuspendController,
SuspendableActivityRegistry {
    private static final Supplier<List<SuspendableActivity>> FACTORY = CopyOnWriteArrayList::new;
    private final List<List<SuspendableActivity>> activityGroups = Stream.generate(FACTORY).limit(SuspendableActivityRegistry.SuspendPriority.LAST.ordinal() + 1).collect(Collectors.toUnmodifiableList());
    private final Map<SuspendableActivity, SuspendableActivityRegistry.SuspendPriority> priorities = Collections.synchronizedMap(new IdentityHashMap());
    private final List<OperationListener> listeners = new CopyOnWriteArrayList<OperationListener>();
    private final AtomicReference<SuspensionStateProvider.State> state = new AtomicReference<SuspensionStateProvider.State>(SuspensionStateProvider.State.SUSPENDED);
    private volatile CompletionStage<Void> activeSuspend = SuspendableActivity.COMPLETED;

    @Override
    public void reset() {
        this.state.getAndSet(SuspensionStateProvider.State.SUSPENDED);
    }

    @Override
    public CompletionStage<Void> suspend(ServerSuspendContext context) {
        if (!this.state.compareAndSet(SuspensionStateProvider.State.RUNNING, SuspensionStateProvider.State.PRE_SUSPEND)) {
            return this.activeSuspend;
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.activeSuspend = result;
        for (OperationListener listener : this.listeners) {
            listener.suspendStarted();
        }
        ArrayList<CompletionStage<Void>> phaseStages = new ArrayList<CompletionStage<Void>>(2);
        result.whenComplete((BiConsumer)SuspendController.propagateCancellation(phaseStages));
        phaseStages.add(SuspendController.phaseStage(this.activityGroups, SuspendableActivity::prepare, context, (ignored, prepareException) -> {
            if (prepareException != null) {
                ServerLogger.ROOT_LOGGER.suspendFailed((Throwable)prepareException);
                result.completeExceptionally(new CancellationException(prepareException.getMessage()));
            } else {
                this.state.set(SuspensionStateProvider.State.SUSPENDING);
                phaseStages.add(SuspendController.phaseStage(this.activityGroups, SuspendableActivity::suspend, context, (ignore, suspendException) -> {
                    if (suspendException != null) {
                        result.completeExceptionally((Throwable)suspendException);
                    } else {
                        this.state.set(SuspensionStateProvider.State.SUSPENDED);
                        result.complete(null);
                        for (OperationListener listener : this.listeners) {
                            listener.complete();
                        }
                    }
                }));
            }
        }));
        return result;
    }

    @Override
    public CompletionStage<Void> resume(ServerResumeContext context) {
        if (this.state.get() == SuspensionStateProvider.State.RUNNING) {
            return SuspendableActivity.COMPLETED;
        }
        this.activeSuspend.toCompletableFuture().cancel(false);
        for (OperationListener listener : this.listeners) {
            listener.cancelled();
        }
        return SuspendController.phaseStage(this::resumeIterator, SuspendableActivity::resume, context, (ignore, exception) -> {
            if (exception == null) {
                this.state.set(SuspensionStateProvider.State.RUNNING);
            }
        });
    }

    private Iterator<List<SuspendableActivity>> resumeIterator() {
        return SuspendController.reverseIterator(this.activityGroups);
    }

    private static <C> CompletionStage<Void> phaseStage(Iterable<List<SuspendableActivity>> activityGroups, final BiFunction<SuspendableActivity, C, CompletionStage<Void>> phase, final C context, BiConsumer<Void, Throwable> completionHandler) {
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        result.whenComplete((BiConsumer)completionHandler);
        final LinkedList<CompletionStage<Void>> groupStages = new LinkedList<CompletionStage<Void>>();
        result.whenComplete((BiConsumer)SuspendController.propagateCancellation(groupStages));
        final Iterator<List<SuspendableActivity>> groups = activityGroups.iterator();
        new BiConsumer<Void, Throwable>(){

            @Override
            public void accept(Void ignore, Throwable exception) {
                if (exception != null) {
                    result.completeExceptionally(exception);
                } else if (!groups.hasNext()) {
                    result.complete(null);
                } else {
                    List<SuspendableActivity> activities = List.copyOf((Collection)groups.next());
                    final CompletableFuture groupStage = new CompletableFuture();
                    groupStages.add(groupStage);
                    groupStage.whenComplete((BiConsumer)this);
                    if (activities.isEmpty()) {
                        groupStage.complete(null);
                    } else {
                        ArrayList<CompletionStage<Void>> stages = new ArrayList<CompletionStage<Void>>(activities.size());
                        groupStage.whenComplete(SuspendController.propagateCancellation(stages));
                        final AtomicInteger activityCounter = new AtomicInteger(activities.size());
                        for (SuspendableActivity activity : activities) {
                            BiConsumer<Void, Throwable> activityCompleter = new BiConsumer<Void, Throwable>(){

                                @Override
                                public void accept(Void ignore, Throwable exception) {
                                    if (exception != null) {
                                        groupStage.completeExceptionally(exception);
                                    } else if (activityCounter.decrementAndGet() == 0) {
                                        groupStage.complete(null);
                                    }
                                }
                            };
                            try {
                                CompletionStage stage = (CompletionStage)phase.apply(activity, context);
                                stages.add(stage);
                                stage.whenComplete(activityCompleter);
                            }
                            catch (Throwable e) {
                                activityCompleter.accept(null, e);
                            }
                        }
                    }
                }
            }
        }.accept(null, null);
        return result;
    }

    static BiConsumer<Void, Throwable> propagateCancellation(final List<CompletionStage<Void>> stages) {
        return new BiConsumer<Void, Throwable>(){

            @Override
            public void accept(Void result, Throwable exception) {
                if (exception instanceof CancellationException) {
                    for (CompletionStage stage : stages) {
                        stage.toCompletableFuture().cancel(false);
                    }
                }
            }
        };
    }

    @Deprecated(forRemoval=true)
    public void nonGracefulStart() {
        this.resume(ServerSuspendController.Context.STARTUP).toCompletableFuture().join();
    }

    @Deprecated(forRemoval=true)
    public void resume() {
        this.resume(ServerSuspendController.Context.RUNNING).toCompletableFuture().join();
    }

    @Deprecated(forRemoval=true)
    public void suspend(long timeoutMillis) {
        ServerLogger.ROOT_LOGGER.suspendingServer(timeoutMillis, TimeUnit.MILLISECONDS);
        CompletableFuture<Void> suspend = this.suspend(ServerSuspendController.Context.RUNNING).toCompletableFuture();
        if (timeoutMillis >= 0L) {
            suspend.completeOnTimeout(null, timeoutMillis, TimeUnit.MILLISECONDS);
        }
        suspend.join();
    }

    private static <E> Iterator<E> reverseIterator(List<E> list) {
        final ListIterator<E> iterator = list.listIterator(list.size());
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasPrevious();
            }

            @Override
            public E next() {
                return iterator.previous();
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                while (this.hasNext()) {
                    action.accept(this.next());
                }
            }
        };
    }

    @Override
    public void registerActivity(SuspendableActivity activity, SuspendableActivityRegistry.SuspendPriority priority) {
        Assert.checkNotNullParam((String)"activity", (Object)activity);
        Assert.checkNotNullParam((String)"priority", (Object)priority);
        if (priority.ordinal() < SuspendableActivityRegistry.SuspendPriority.FIRST.ordinal() || priority.ordinal() > SuspendableActivityRegistry.SuspendPriority.LAST.ordinal()) {
            throw new IllegalArgumentException(String.valueOf(priority.ordinal()));
        }
        if (this.priorities.putIfAbsent(activity, priority) == null) {
            this.activityGroups.get(priority.ordinal()).add(activity);
            if (this.state.get() != SuspensionStateProvider.State.RUNNING) {
                activity.suspend(ServerSuspendController.Context.STARTUP).toCompletableFuture().join();
            }
        }
    }

    @Override
    public void unregisterActivity(SuspendableActivity activity) {
        SuspendableActivityRegistry.SuspendPriority priority = this.priorities.remove(activity);
        if (priority != null) {
            this.activityGroups.get(priority.ordinal()).remove(activity);
        }
    }

    @Override
    public SuspensionStateProvider.State getState() {
        return this.state.get();
    }

    @Override
    public void addListener(OperationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(OperationListener listener) {
        this.listeners.remove(listener);
    }

    @Deprecated(forRemoval=true)
    public void setStartSuspended(boolean startSuspended) {
        this.reset();
    }

    @Deprecated(forRemoval=true)
    public void registerActivity(ServerActivity activity) {
        this.registerActivity(activity, SuspendableActivityRegistry.SuspendPriority.of(activity.getExecutionGroup()));
    }

    @Deprecated(forRemoval=true)
    public void unRegisterActivity(ServerActivity activity) {
        this.unregisterActivity(activity);
    }
}

