/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.security;

import java.util.function.UnaryOperator;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

public class VirtualDomainMetaData {
    private final UnaryOperator<SecurityIdentity> securityIdentityTransformer;
    private final AuthMethod authMethod;
    private SecurityDomain securityDomain;

    VirtualDomainMetaData(Builder builder) {
        this.securityIdentityTransformer = builder.securityIdentityTransformer;
        this.authMethod = builder.authMethod;
    }

    public synchronized SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public synchronized void setSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public UnaryOperator<SecurityIdentity> getSecurityIdentityTransformer() {
        return this.securityIdentityTransformer;
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private UnaryOperator<SecurityIdentity> securityIdentityTransformer;
        private AuthMethod authMethod;

        public VirtualDomainMetaData build() {
            return new VirtualDomainMetaData(this);
        }

        public void setSecurityIdentityTransformer(UnaryOperator<SecurityIdentity> securityIdentityTransformer) {
            Assert.checkNotNullParam((String)"securityIdentityTransformer", securityIdentityTransformer);
            this.securityIdentityTransformer = securityIdentityTransformer;
        }

        public void setAuthMethod(AuthMethod authMethod) {
            Assert.checkNotNullParam((String)"authMethod", (Object)((Object)authMethod));
            this.authMethod = authMethod;
        }
    }

    public static enum AuthMethod {
        OIDC("OIDC"),
        MP_JWT("MP-JWT");

        private final String name;

        private AuthMethod(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static AuthMethod forName(String name) {
            switch (name) {
                case "OIDC": {
                    return OIDC;
                }
                case "MP-JWT": {
                    return MP_JWT;
                }
            }
            return null;
        }
    }
}

