/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.server.ElapsedTime;
import org.jboss.as.server.FutureServiceContainer;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StabilityStatistics;

public final class BootstrapListener {
    public static final String MARKER_FILE = "startup-marker";
    private final StabilityMonitor monitor = new StabilityMonitor();
    private final ServiceContainer serviceContainer;
    private final ServiceTarget serviceTarget;
    private final ElapsedTime elapsedTime;
    private final String prettyVersion;
    private final FutureServiceContainer futureContainer;
    private final File tempDir;
    private String startedCleanMessage;
    private String startedWitErrorsMessage;

    public BootstrapListener(ServiceContainer serviceContainer, ElapsedTime elapsedTime, ServiceTarget serviceTarget, FutureServiceContainer futureContainer, String prettyVersion, File tempDir) {
        this.serviceContainer = serviceContainer;
        this.elapsedTime = elapsedTime;
        this.serviceTarget = serviceTarget;
        this.prettyVersion = prettyVersion;
        this.futureContainer = futureContainer;
        this.tempDir = tempDir;
        serviceTarget.addMonitor(this.monitor);
    }

    public StabilityMonitor getStabilityMonitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBootStatistics(String ... messages) {
        StabilityStatistics statistics = new StabilityStatistics();
        try {
            this.monitor.awaitStability(statistics);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.serviceTarget.removeMonitor(this.monitor);
            long bootstrapTime = this.elapsedTime.getElapsedTime();
            this.done(bootstrapTime, statistics, messages);
            this.monitor.clear();
        }
    }

    public void printBootStatisticsMessage() {
        if (this.startedCleanMessage != null) {
            ServerLogger.AS_ROOT_LOGGER.startedClean(this.startedCleanMessage);
        } else if (this.startedWitErrorsMessage != null) {
            ServerLogger.AS_ROOT_LOGGER.startedWitErrors(this.startedWitErrorsMessage);
        }
        this.startedCleanMessage = null;
        this.startedWitErrorsMessage = null;
    }

    public void bootFailure(Throwable throwable) {
        this.futureContainer.failed(throwable);
    }

    private void done(long bootstrapTime, StabilityStatistics statistics, String ... messages) {
        this.futureContainer.done(this.serviceContainer);
        if (this.serviceContainer.isShutdown()) {
            return;
        }
        int active = statistics.getActiveCount();
        int failed = statistics.getFailedCount();
        int lazy = statistics.getLazyCount();
        int never = statistics.getNeverCount();
        int onDemand = statistics.getOnDemandCount();
        int passive = statistics.getPassiveCount();
        int problem = statistics.getProblemsCount();
        int started = statistics.getStartedCount();
        String appendMessage = "";
        if (messages != null) {
            appendMessage = String.join((CharSequence)" ", messages);
        }
        if (failed == 0 && problem == 0) {
            this.startedCleanMessage = ServerLogger.AS_ROOT_LOGGER.startedCleanMessage(this.prettyVersion, bootstrapTime, started, active + passive + onDemand + never + lazy, onDemand + passive + lazy, appendMessage);
            this.createStartupMarker("success", this.elapsedTime.getStartTime());
        } else {
            this.startedWitErrorsMessage = ServerLogger.AS_ROOT_LOGGER.startedWitErrorsMessage(this.prettyVersion, bootstrapTime, started, active + passive + onDemand + never + lazy, failed + problem, onDemand + passive + lazy, appendMessage);
            this.createStartupMarker("error", this.elapsedTime.getStartTime());
        }
    }

    private void createStartupMarker(String result, long startTime) {
        block10: {
            File file = new File(this.tempDir, MARKER_FILE);
            try {
                Files.deleteIfExists(file.toPath());
                if (!file.createNewFile()) break block10;
                try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, StandardOpenOption.WRITE);){
                    writer.append(result).append(":").append(String.valueOf(startTime));
                    writer.flush();
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void deleteStartupMarker(File tempDir) {
        File file = new File(tempDir, MARKER_FILE);
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void logAdminConsole() {
        ServiceController controller = this.serviceContainer.getService(UndertowHttpManagementService.SERVICE_NAME);
        if (controller != null) {
            boolean hasHttps;
            HttpManagement mgmt = (HttpManagement)controller.getValue();
            boolean hasHttp = mgmt.getHttpNetworkInterfaceBinding() != null;
            boolean bl = hasHttps = mgmt.getHttpsNetworkInterfaceBinding() != null;
            if (hasHttp && hasHttps) {
                ServerLogger.AS_ROOT_LOGGER.logHttpAndHttpsManagement(NetworkUtils.formatIPAddressForURI((InetAddress)mgmt.getHttpNetworkInterfaceBinding().getAddress()), mgmt.getHttpPort(), NetworkUtils.formatIPAddressForURI((InetAddress)mgmt.getHttpsNetworkInterfaceBinding().getAddress()), mgmt.getHttpsPort());
                if (mgmt.hasConsole()) {
                    ServerLogger.AS_ROOT_LOGGER.logHttpAndHttpsConsole(NetworkUtils.formatIPAddressForURI((InetAddress)mgmt.getHttpNetworkInterfaceBinding().getAddress()), mgmt.getHttpPort(), NetworkUtils.formatIPAddressForURI((InetAddress)mgmt.getHttpsNetworkInterfaceBinding().getAddress()), mgmt.getHttpsPort());
                } else {
                    ServerLogger.AS_ROOT_LOGGER.logNoConsole();
                }
            } else if (hasHttp) {
                ServerLogger.AS_ROOT_LOGGER.logHttpManagement(NetworkUtils.formatIPAddressForURI((InetAddress)mgmt.getHttpNetworkInterfaceBinding().getAddress()), mgmt.getHttpPort());
                if (mgmt.hasConsole()) {
                    ServerLogger.AS_ROOT_LOGGER.logHttpConsole(NetworkUtils.formatIPAddressForURI((InetAddress)mgmt.getHttpNetworkInterfaceBinding().getAddress()), mgmt.getHttpPort());
                } else {
                    ServerLogger.AS_ROOT_LOGGER.logNoConsole();
                }
            } else if (hasHttps) {
                ServerLogger.AS_ROOT_LOGGER.logHttpsManagement(NetworkUtils.formatIPAddressForURI((InetAddress)mgmt.getHttpsNetworkInterfaceBinding().getAddress()), mgmt.getHttpsPort());
                if (mgmt.hasConsole()) {
                    ServerLogger.AS_ROOT_LOGGER.logHttpsConsole(NetworkUtils.formatIPAddressForURI((InetAddress)mgmt.getHttpsNetworkInterfaceBinding().getAddress()), mgmt.getHttpsPort());
                } else {
                    ServerLogger.AS_ROOT_LOGGER.logNoConsole();
                }
            } else {
                ServerLogger.AS_ROOT_LOGGER.logNoHttpManagement();
                ServerLogger.AS_ROOT_LOGGER.logNoConsole();
            }
        }
    }
}

