/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import java.util.function.Function;
import javax.transaction.xa.Xid;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.transaction.RequestType;
import org.wildfly.httpclient.transaction.ServerHandlers;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;

public class HttpRemoteTransactionService {
    private final HttpServiceConfig config;
    private final ServerHandlers serverHandlers;

    public HttpRemoteTransactionService(LocalTransactionContext transactionContext, Function<LocalTransaction, Xid> xidResolver) {
        this(HttpServiceConfig.getInstance(), transactionContext, xidResolver);
    }

    private HttpRemoteTransactionService(HttpServiceConfig config, LocalTransactionContext transactionContext, Function<LocalTransaction, Xid> xidResolver) {
        this.config = config;
        this.serverHandlers = ServerHandlers.newInstance(config, transactionContext, xidResolver);
    }

    public HttpHandler createHandler() {
        RoutingHandler routingHandler = new RoutingHandler();
        for (RequestType requestType : RequestType.values()) {
            this.registerHandler(routingHandler, requestType);
        }
        return this.config.wrap((HttpHandler)new BlockingHandler((HttpHandler)new ElytronIdentityHandler((HttpHandler)routingHandler)));
    }

    private void registerHandler(RoutingHandler routingHandler, RequestType requestType) {
        routingHandler.add(requestType.getMethod(), requestType.getPath(), this.serverHandlers.handlerOf(requestType));
    }
}

