/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.rxjava2.propagation;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.concurrent.Executor;
import org.jboss.resteasy.concurrent.ContextualExecutors;

class ContextPropagatorOnMaybeCreateAction
implements BiFunction<Maybe, MaybeObserver, MaybeObserver> {
    ContextPropagatorOnMaybeCreateAction() {
    }

    public MaybeObserver apply(Maybe maybe, MaybeObserver observer) throws Exception {
        return new ContextCapturerMaybe(maybe, observer, ContextualExecutors.executor());
    }

    private static class ContextCapturerMaybe<T>
    implements MaybeObserver<T> {
        private final MaybeObserver<T> source;
        private final Executor contextExecutor;

        private ContextCapturerMaybe(Maybe<T> observable, MaybeObserver<T> observer, Executor contextExecutor) {
            this.source = observer;
            this.contextExecutor = contextExecutor;
        }

        public void onComplete() {
            this.contextExecutor.execute(() -> this.source.onComplete());
        }

        public void onError(Throwable t) {
            this.contextExecutor.execute(() -> this.source.onError(t));
        }

        public void onSubscribe(Disposable d) {
            this.contextExecutor.execute(() -> this.source.onSubscribe(d));
        }

        public void onSuccess(T v) {
            this.contextExecutor.execute(() -> this.source.onSuccess(v));
        }
    }
}

