/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.processor.JPADelegatingClassFileTransformer;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.DelegatingClassTransformer;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.ClassTransformer;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class JPAClassFileTransformerProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        this.setClassLoaderTransformer(deploymentUnit);
    }

    private void setClassLoaderTransformer(DeploymentUnit deploymentUnit) {
        DelegatingClassTransformer transformer = (DelegatingClassTransformer)deploymentUnit.getAttachment(DelegatingClassTransformer.ATTACHMENT_KEY);
        if (transformer != null) {
            for (ResourceRoot resourceRoot : DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit)) {
                PersistenceUnitMetadataHolder holder = (PersistenceUnitMetadataHolder)resourceRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
                if (holder == null) continue;
                for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                    if (!pu.needsJPADelegatingClassFileTransformer()) continue;
                    transformer.addTransformer((ClassTransformer)new JPADelegatingClassFileTransformer(pu));
                }
            }
        }
    }
}

