/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.opentelemetry.api.OpenTelemetry;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.amqp.AmqpConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.amqp.AmqpCreditBasedSender;
import io.smallrye.reactive.messaging.amqp.ChannelUtils;
import io.smallrye.reactive.messaging.amqp.ConnectionHolder;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPLogging;
import io.smallrye.reactive.messaging.providers.helpers.MultiUtils;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.mutiny.amqp.AmqpClient;
import io.vertx.mutiny.amqp.AmqpSender;
import io.vertx.mutiny.core.Vertx;
import io.vertx.proton.ProtonSender;
import jakarta.enterprise.inject.Instance;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.eclipse.microprofile.reactive.messaging.Message;

public class OutgoingAmqpChannel {
    private final AtomicBoolean opened;
    private final Flow.Subscriber<Message<?>> subscriber;
    private final AmqpCreditBasedSender processor;

    public OutgoingAmqpChannel(AmqpConnectorOutgoingConfiguration oc, AmqpClient client, Vertx vertx, Instance<OpenTelemetry> openTelemetryInstance, BiConsumer<String, Throwable> reportFailure) {
        String configuredAddress = oc.getAddress().orElseGet(oc::getChannel);
        this.opened = new AtomicBoolean(false);
        AtomicReference sender = new AtomicReference();
        String link = oc.getLinkName().orElseGet(oc::getChannel);
        ConnectionHolder holder = new ConnectionHolder(client, oc, vertx, null);
        Uni getSender = Uni.createFrom().deferred(() -> {
            AmqpSender current = (AmqpSender)sender.get();
            if (current != null && !current.connection().isDisconnected()) {
                if (this.isLinkOpen(current)) {
                    return Uni.createFrom().item((Object)current);
                }
                current.closeAndForget();
            }
            return holder.getOrEstablishConnection().onItem().transformToUni(connection -> {
                boolean anonymous = oc.getUseAnonymousSender().orElseGet(() -> ConnectionHolder.supportAnonymousRelay(connection));
                if (anonymous) {
                    return connection.createAnonymousSender();
                }
                return connection.createSender(configuredAddress, new AmqpSenderOptions().setLinkName(link).setCapabilities(ChannelUtils.getClientCapabilities(oc)));
            }).onItem().invoke(s -> {
                AmqpSender orig = sender.getAndSet(s);
                if (orig != null) {
                    orig.closeAndForget();
                }
                this.opened.set(true);
            });
        }).onFailure().invoke(t -> {
            sender.set(null);
            this.opened.set(false);
        }).onCancellation().invoke(() -> {
            sender.set(null);
            this.opened.set(false);
        });
        this.processor = new AmqpCreditBasedSender(holder, oc, (Uni<AmqpSender>)getSender, openTelemetryInstance);
        holder.onFailure(t -> {
            this.opened.set(false);
            if (!oc.getLazyClient().booleanValue()) {
                this.processor.isConnected().subscribe().with(this.opened::set, e -> {
                    AMQPLogging.log.failureReported(oc.getChannel(), (Throwable)e);
                    this.opened.set(false);
                    reportFailure.accept(oc.getChannel(), (Throwable)e);
                });
            }
        });
        this.subscriber = MultiUtils.via((Flow.Processor)this.processor, m -> m.onFailure().invoke(t -> {
            AMQPLogging.log.failureReported(oc.getChannel(), (Throwable)t);
            this.opened.set(false);
            reportFailure.accept(oc.getChannel(), (Throwable)t);
        }));
    }

    private boolean isLinkOpen(AmqpSender current) {
        ProtonSender sender = current.getDelegate().unwrap();
        if (sender == null) {
            return false;
        }
        return sender.isOpen();
    }

    public boolean isOpen() {
        return this.opened.get();
    }

    public Flow.Subscriber<? extends Message<?>> getSubscriber() {
        return this.subscriber;
    }

    public Uni<Boolean> isConnected() {
        return this.processor.isConnected();
    }

    public long getHealthTimeout() {
        return this.processor.getHealthTimeout();
    }

    public void close() {
        this.processor.cancel();
        this.opened.set(false);
    }
}

