/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.CompositeSessionFactory;
import org.wildfly.clustering.session.cache.SessionFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.metadata.ImmutableSessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionMetaDataEntry;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionAccessMetaDataKey;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionCreationMetaDataKey;

@ClientListener
public class HotRodSessionFactory<DC, AV, SC>
extends CompositeSessionFactory<DC, SessionMetaDataEntry<SC>, AV, SC> {
    private static final System.Logger LOGGER = System.getLogger(HotRodSessionFactory.class.getName());
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<SC>> creationMetaDataCache;
    private final ImmutableSessionMetaDataFactory<SessionMetaDataEntry<SC>> metaDataFactory;
    private final SessionAttributesFactory<DC, AV> attributesFactory;
    private final Consumer<ImmutableSession> expirationListener;
    private final Executor executor;

    public HotRodSessionFactory(Configuration<DC, AV, SC> configuration) {
        super(configuration);
        this.metaDataFactory = configuration.getSessionMetaDataFactory();
        this.attributesFactory = configuration.getSessionAttributesFactory();
        this.expirationListener = configuration.getSessionExpirationListener();
        this.creationMetaDataCache = configuration.getCacheConfiguration().getForceReturnCache();
        this.executor = configuration.getCacheConfiguration().getExecutor();
        this.creationMetaDataCache.addClientListener((Object)this);
    }

    public void close() {
        this.creationMetaDataCache.removeClientListener((Object)this);
        super.close();
    }

    @ClientCacheEntryExpired
    public void expired(ClientCacheEntryExpiredEvent<SessionAccessMetaDataKey> event) {
        final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<SC>> creationMetaDataCache = this.creationMetaDataCache;
        final ImmutableSessionMetaDataFactory<SessionMetaDataEntry<SC>> metaDataFactory = this.metaDataFactory;
        final SessionAttributesFactory<DC, AV> attributesFactory = this.attributesFactory;
        final Consumer<ImmutableSession> expirationListener = this.expirationListener;
        final String id = (String)((SessionAccessMetaDataKey)((Object)event.getKey())).getId();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Object attributesValue;
                SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)creationMetaDataCache.remove((Object)new SessionCreationMetaDataKey(id));
                if (creationMetaDataEntry != null && (attributesValue = attributesFactory.findValue((Object)id)) != null) {
                    DefaultSessionAccessMetaDataEntry accessMetaData = new DefaultSessionAccessMetaDataEntry();
                    Duration lastAccess = Duration.ofSeconds(1L);
                    Duration sinceCreation = Duration.between(creationMetaDataEntry.getCreationTime(), Instant.now()).minus(creationMetaDataEntry.getTimeout()).minus(lastAccess);
                    accessMetaData.setLastAccessDuration(sinceCreation, lastAccess);
                    ImmutableSessionMetaData metaData = metaDataFactory.createImmutableSessionMetaData(id, (Object)new DefaultSessionMetaDataEntry(creationMetaDataEntry, (SessionAccessMetaDataEntry)accessMetaData));
                    Map attributes = attributesFactory.createImmutableSessionAttributes(id, attributesValue);
                    ImmutableSession session = HotRodSessionFactory.this.createImmutableSession(id, metaData, attributes);
                    LOGGER.log(System.Logger.Level.TRACE, "Session {0} has expired.", id);
                    expirationListener.accept(session);
                    attributesFactory.remove((Object)id);
                }
            }
        };
        this.executor.execute(task);
    }

    static interface Configuration<DC, AV, SC>
    extends SessionFactoryConfiguration<DC, SessionMetaDataEntry<SC>, AV, SC> {
        public RemoteCacheConfiguration getCacheConfiguration();

        default public CacheProperties getCacheProperties() {
            return this.getCacheConfiguration().getCacheProperties();
        }

        public Consumer<ImmutableSession> getSessionExpirationListener();
    }
}

