/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.jbossts;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.spi.transaction.xa.XidWrapper;
import org.jboss.jca.core.tx.jbossts.XidWrapperImpl;
import org.jboss.logging.Logger;
import org.jboss.tm.XAResourceWrapper;

public class XAResourceWrapperImpl
implements org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper,
XAResourceWrapper {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)XAResourceWrapperImpl.class.getName());
    private final XAResource xaResource;
    private final boolean pad;
    private final Boolean overrideRmValue;
    private final String productName;
    private final String productVersion;
    private final String jndiName;
    private transient int cachedHashCode;

    public XAResourceWrapperImpl(XAResource resource, String productName, String productVersion) {
        this(resource, false, null, productName, productVersion, null);
    }

    public XAResourceWrapperImpl(XAResource resource, boolean pad, Boolean override, String productName, String productVersion, String jndiName) {
        this.overrideRmValue = override;
        this.pad = pad;
        this.xaResource = resource;
        this.productName = productName;
        this.productVersion = productVersion;
        this.jndiName = jndiName;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.pad) {
            xid = this.convertXid(xid);
        }
        this.xaResource.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this.pad) {
            xid = this.convertXid(xid);
        }
        this.xaResource.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        if (this.pad) {
            xid = this.convertXid(xid);
        }
        this.xaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (this.overrideRmValue != null) {
            if (log.isTraceEnabled()) {
                log.trace("Executing isSameRM with override value" + this.overrideRmValue + " for XAResourceWrapper" + String.valueOf(this));
            }
            return this.overrideRmValue;
        }
        if (resource instanceof org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper) {
            org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper other = (org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper)resource;
            return this.xaResource.isSameRM(other.getResource());
        }
        return this.xaResource.isSameRM(resource);
    }

    public int prepare(Xid xid) throws XAException {
        if (this.pad) {
            xid = this.convertXid(xid);
        }
        return this.xaResource.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        if (this.pad) {
            xid = this.convertXid(xid);
        }
        this.xaResource.rollback(xid);
    }

    public boolean setTransactionTimeout(int flag) throws XAException {
        return this.xaResource.setTransactionTimeout(flag);
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.pad) {
            xid = this.convertXid(xid);
        }
        this.xaResource.start(xid, flags);
    }

    public XAResource getResource() {
        return this.xaResource;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    private Xid convertXid(Xid xid) {
        if (xid instanceof XidWrapper) {
            return xid;
        }
        return new XidWrapperImpl(xid, this.pad, this.jndiName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof XAResourceWrapperImpl)) {
            return false;
        }
        XAResourceWrapperImpl other = (XAResourceWrapperImpl)object;
        if (this.xaResource != null ? !this.xaResource.equals(other.xaResource) : other.xaResource != null) {
            return false;
        }
        if (this.pad != other.pad) {
            return false;
        }
        if (this.overrideRmValue != null ? !this.overrideRmValue.equals(other.overrideRmValue) : other.overrideRmValue != null) {
            return false;
        }
        if (this.productName != null ? !this.productName.equals(other.productName) : other.productName != null) {
            return false;
        }
        if (this.productVersion != null ? !this.productVersion.equals(other.productVersion) : other.productVersion != null) {
            return false;
        }
        return !(this.jndiName != null ? !this.jndiName.equals(other.jndiName) : other.jndiName != null);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int result = 31;
            result += this.xaResource != null ? 7 * this.xaResource.hashCode() : 7;
            result += this.pad ? 7 : 1;
            result += this.overrideRmValue != null ? 7 * this.overrideRmValue.hashCode() : 7;
            result += this.productName != null ? 7 * this.productName.hashCode() : 7;
            result += this.productVersion != null ? 7 * this.productVersion.hashCode() : 7;
            this.cachedHashCode = result += this.jndiName != null ? 7 * this.jndiName.hashCode() : 7;
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XAResourceWrapperImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[xaResource=").append(this.xaResource);
        sb.append(" pad=").append(this.pad);
        sb.append(" overrideRmValue=").append(this.overrideRmValue);
        sb.append(" productName=").append(this.productName);
        sb.append(" productVersion=").append(this.productVersion);
        sb.append(" jndiName=").append(this.jndiName);
        sb.append("]");
        return sb.toString();
    }
}

