/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;

public class PutIndexMappingWork
extends AbstractNonBulkableWork<Void> {
    protected PutIndexMappingWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    public static class Builder
    extends AbstractNonBulkableWork.AbstractBuilder<Builder> {
        private final URLEncodedString indexName;
        private final JsonObject payload;

        public static Builder create(GsonProvider gsonProvider, URLEncodedString indexName, RootTypeMapping typeMapping) {
            return new Builder(gsonProvider, indexName, typeMapping);
        }

        private Builder(GsonProvider gsonProvider, URLEncodedString indexName, RootTypeMapping typeMapping) {
            super(ElasticsearchRequestSuccessAssessor.DEFAULT_INSTANCE);
            this.indexName = indexName;
            Gson gson = gsonProvider.getGsonNoSerializeNulls();
            this.payload = gson.toJsonTree((Object)typeMapping).getAsJsonObject();
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName);
            builder.pathComponent(Paths._MAPPING).body(this.payload);
            return builder.build();
        }

        public PutIndexMappingWork build() {
            return new PutIndexMappingWork(this);
        }
    }
}

