/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;

public interface Validator<T> {
    public void validate(ValidationErrorCollector var1, T var2, T var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void validateAllIgnoreUnexpected(ValidationErrorCollector errorCollector, ValidationContextType type, String messageIfMissing, Map<String, ? extends T> expectedMap, Map<String, ? extends T> actualMap) {
        if (expectedMap == null || expectedMap.isEmpty()) {
            return;
        }
        if (actualMap == null) {
            actualMap = Collections.emptyMap();
        }
        for (Map.Entry<String, T> entry : expectedMap.entrySet()) {
            String name = entry.getKey();
            T expected = entry.getValue();
            Object actual = actualMap.get(name);
            errorCollector.push(type, name);
            try {
                if (actual == null) {
                    errorCollector.addError(messageIfMissing);
                    continue;
                }
                this.validate(errorCollector, expected, actual);
            }
            finally {
                errorCollector.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void validateAllIncludingUnexpected(ValidationErrorCollector errorCollector, ValidationContextType type, Map<String, ? extends T> expectedMap, Map<String, ? extends T> actualMap) {
        if (expectedMap == null) {
            expectedMap = Collections.emptyMap();
        }
        if (actualMap == null) {
            actualMap = Collections.emptyMap();
        }
        HashSet<String> namesToValidate = new HashSet<String>();
        namesToValidate.addAll(expectedMap.keySet());
        namesToValidate.addAll(actualMap.keySet());
        for (String name : namesToValidate) {
            errorCollector.push(type, name);
            try {
                Object expected = expectedMap.get(name);
                Object actual = actualMap.get(name);
                this.validate(errorCollector, expected, actual);
            }
            finally {
                errorCollector.pop();
            }
        }
    }
}

