/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.function.Consumer;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.PropertyMappingIndexSettingsContributor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.FromDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.backend.types.spi.AbstractIndexValueFieldType;

public class ElasticsearchIndexValueFieldType<F>
extends AbstractIndexValueFieldType<ElasticsearchSearchIndexScope<?>, ElasticsearchSearchIndexValueFieldContext<F>, F>
implements ElasticsearchSearchIndexValueFieldTypeContext<F> {
    private final JsonPrimitive elasticsearchTypeAsJson;
    private final ElasticsearchFieldCodec<F> codec;
    private final PropertyMapping mapping;
    private final Consumer<PropertyMappingIndexSettingsContributor> indexSettingsContributor;
    private final ProjectionConverter<?, ?> rawProjectionConverter;
    private final DslConverter<?, ?> rawDslConverter;

    public ElasticsearchIndexValueFieldType(Builder<F> builder) {
        super(builder);
        this.elasticsearchTypeAsJson = builder.elasticsearchTypeAsJson();
        this.codec = builder.codec;
        this.mapping = builder.mapping;
        this.indexSettingsContributor = builder.indexSettingsContributor;
        this.rawProjectionConverter = new ProjectionConverter(String.class, new RawProjectionConverter<F>(this.codec));
        this.rawDslConverter = new DslConverter(String.class, new RawDslConverter<F>(this.codec));
    }

    @Override
    public JsonPrimitive elasticsearchTypeAsJson() {
        return this.elasticsearchTypeAsJson;
    }

    @Override
    public ElasticsearchFieldCodec<F> codec() {
        return this.codec;
    }

    @Override
    public boolean hasNormalizerOnAtLeastOneIndex() {
        return this.normalizerName().isPresent();
    }

    public PropertyMapping mapping() {
        return this.mapping;
    }

    public Optional<Consumer<PropertyMappingIndexSettingsContributor>> additionalIndexSettings() {
        return Optional.ofNullable(this.indexSettingsContributor);
    }

    public DslConverter<?, ?> rawDslConverter() {
        return this.rawDslConverter;
    }

    public ProjectionConverter<?, ?> rawProjectionConverter() {
        return this.rawProjectionConverter;
    }

    public static class Builder<F>
    extends AbstractIndexValueFieldType.Builder<ElasticsearchSearchIndexScope<?>, ElasticsearchSearchIndexValueFieldContext<F>, F> {
        private ElasticsearchFieldCodec<F> codec;
        private final PropertyMapping mapping;
        private Consumer<PropertyMappingIndexSettingsContributor> indexSettingsContributor;

        public Builder(Class<F> valueType, PropertyMapping mapping) {
            super(valueType);
            this.mapping = mapping;
        }

        public void codec(ElasticsearchFieldCodec<F> codec) {
            this.codec = codec;
        }

        public ElasticsearchFieldCodec<F> codec() {
            return this.codec;
        }

        public PropertyMapping mapping() {
            return this.mapping;
        }

        public void contributeAdditionalIndexSettings(Consumer<PropertyMappingIndexSettingsContributor> indexSettingsContributor) {
            this.indexSettingsContributor = indexSettingsContributor;
        }

        public ElasticsearchIndexValueFieldType<F> build() {
            return new ElasticsearchIndexValueFieldType(this);
        }

        private JsonPrimitive elasticsearchTypeAsJson() {
            String typeName = this.mapping.getType();
            if (typeName == null) {
                typeName = "object";
            }
            return new JsonPrimitive(typeName);
        }
    }

    private static class RawProjectionConverter<F>
    implements FromDocumentValueConverter<JsonElement, String> {
        private final ElasticsearchFieldCodec<F> codec;

        private RawProjectionConverter(ElasticsearchFieldCodec<F> codec) {
            this.codec = codec;
        }

        public String fromDocumentValue(JsonElement value, FromDocumentValueConvertContext context) {
            return this.codec.fromJsonElementToString(value);
        }

        public boolean isCompatibleWith(FromDocumentValueConverter<?, ?> other) {
            if (!(other instanceof RawProjectionConverter)) {
                return false;
            }
            return this.codec.isCompatibleWith(((RawProjectionConverter)other).codec);
        }
    }

    private static class RawDslConverter<F>
    implements ToDocumentValueConverter<String, JsonElement> {
        private final ElasticsearchFieldCodec<F> codec;

        private RawDslConverter(ElasticsearchFieldCodec<F> codec) {
            this.codec = codec;
        }

        public JsonElement toDocumentValue(String value, ToDocumentValueConvertContext context) {
            return this.codec.fromJsonStringToElement(value);
        }

        public boolean isCompatibleWith(ToDocumentValueConverter<?, ?> other) {
            if (!(other instanceof RawDslConverter)) {
                return false;
            }
            return this.codec.isCompatibleWith(((RawDslConverter)other).codec);
        }
    }
}

