/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchBatchedWorkProcessor;
import org.hibernate.search.backend.elasticsearch.work.impl.IndexingWork;
import org.hibernate.search.engine.backend.orchestration.spi.BatchedWork;
import org.hibernate.search.util.common.impl.Futures;

class ElasticsearchBatchedWork<T>
implements BatchedWork<ElasticsearchBatchedWorkProcessor> {
    private final IndexingWork<T> work;
    private final CompletableFuture<T> future;

    ElasticsearchBatchedWork(IndexingWork<T> work, CompletableFuture<T> future) {
        this.work = work;
        this.future = future;
    }

    public void submitTo(ElasticsearchBatchedWorkProcessor delegate) {
        delegate.submit(this.work).whenComplete(Futures.copyHandler(this.future));
    }

    public void markAsFailed(Throwable t) {
        this.future.completeExceptionally(t);
    }

    String getQueuingKey() {
        return this.work.getQueuingKey();
    }
}

