/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.GsonBuilder;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchBackendSettings;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientUtils;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClient;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientFactory;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.dialect.impl.ElasticsearchDialectFactory;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.ElasticsearchProtocolDialect;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.impl.IndexNamesRegistry;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.metadata.impl.ElasticsearchIndexMetadataSyntax;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.mapping.impl.TypeNameMapping;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.resources.impl.BackendThreads;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultExtractorFactory;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchLinkImpl
implements ElasticsearchLink {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final OptionalConfigurationProperty<ElasticsearchVersion> VERSION = ConfigurationProperty.forKey((String)"version").as(ElasticsearchVersion.class, ElasticsearchVersion::of).build();
    private static final OptionalConfigurationProperty<Boolean> VERSION_CHECK_ENABLED = ConfigurationProperty.forKey((String)"version_check.enabled").asBoolean().build();
    private static final ConfigurationProperty<Integer> SCROLL_TIMEOUT = ConfigurationProperty.forKey((String)"scroll_timeout").asIntegerStrictlyPositive().withDefault((Object)60).build();
    private static final ConfigurationProperty<Boolean> QUERY_SHARD_FAILURE_IGNORE = ConfigurationProperty.forKey((String)"query.shard_failure.ignore").asBoolean().withDefault((Object)false).build();
    private static final ConfigurationProperty<BeanReference<? extends IndexLayoutStrategy>> LAYOUT_STRATEGY = ConfigurationProperty.forKey((String)"layout.strategy").asBeanReference(IndexLayoutStrategy.class).withDefault(ElasticsearchBackendSettings.Defaults.LAYOUT_STRATEGY).build();
    private final BeanHolder<? extends ElasticsearchClientFactory> clientFactoryHolder;
    private final BackendThreads threads;
    private final GsonProvider defaultGsonProvider;
    private final boolean logPrettyPrinting;
    private final ElasticsearchDialectFactory dialectFactory;
    private final Optional<ElasticsearchVersion> configuredVersionOnBackendCreationOptional;
    private final TypeNameMapping typeNameMapping;
    private final IndexNamesRegistry indexNamesRegistry;
    private ElasticsearchClientImplementor clientImplementor;
    private ElasticsearchVersion elasticsearchVersion;
    private GsonProvider gsonProvider;
    private ElasticsearchIndexMetadataSyntax indexMetadataSyntax;
    private ElasticsearchSearchSyntax searchSyntax;
    private ElasticsearchWorkFactory workFactory;
    private ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory;
    private Integer scrollTimeout;
    private BeanHolder<? extends IndexLayoutStrategy> indexLayoutStrategyHolder;
    private SearchProjectionBackendContext searchProjectionBackendContext;

    ElasticsearchLinkImpl(BeanHolder<? extends ElasticsearchClientFactory> clientFactoryHolder, BackendThreads threads, GsonProvider defaultGsonProvider, boolean logPrettyPrinting, ElasticsearchDialectFactory dialectFactory, Optional<ElasticsearchVersion> configuredVersionOnBackendCreationOptional, TypeNameMapping typeNameMapping) {
        this.clientFactoryHolder = clientFactoryHolder;
        this.threads = threads;
        this.defaultGsonProvider = defaultGsonProvider;
        this.logPrettyPrinting = logPrettyPrinting;
        this.dialectFactory = dialectFactory;
        this.configuredVersionOnBackendCreationOptional = configuredVersionOnBackendCreationOptional;
        this.typeNameMapping = typeNameMapping;
        this.indexNamesRegistry = new IndexNamesRegistry();
    }

    @Override
    public ElasticsearchClient getClient() {
        this.checkStarted();
        return this.clientImplementor;
    }

    @Override
    public GsonProvider getGsonProvider() {
        this.checkStarted();
        return this.gsonProvider;
    }

    @Override
    public ElasticsearchIndexMetadataSyntax getIndexMetadataSyntax() {
        this.checkStarted();
        return this.indexMetadataSyntax;
    }

    @Override
    public ElasticsearchSearchSyntax getSearchSyntax() {
        this.checkStarted();
        return this.searchSyntax;
    }

    @Override
    public ElasticsearchWorkFactory getWorkFactory() {
        this.checkStarted();
        return this.workFactory;
    }

    @Override
    public ElasticsearchSearchResultExtractorFactory getSearchResultExtractorFactory() {
        this.checkStarted();
        return this.searchResultExtractorFactory;
    }

    @Override
    public Integer getScrollTimeout() {
        this.checkStarted();
        return this.scrollTimeout;
    }

    @Override
    public IndexLayoutStrategy getIndexLayoutStrategy() {
        this.checkStarted();
        return (IndexLayoutStrategy)this.indexLayoutStrategyHolder.get();
    }

    @Override
    public TypeNameMapping getTypeNameMapping() {
        return this.typeNameMapping;
    }

    @Override
    public IndexNames createIndexNames(String hibernateSearchIndexName, String mappedTypeName) {
        this.checkStarted();
        IndexLayoutStrategy indexLayoutStrategy = (IndexLayoutStrategy)this.indexLayoutStrategyHolder.get();
        URLEncodedString writeAlias = IndexNames.encodeName(indexLayoutStrategy.createWriteAlias(hibernateSearchIndexName));
        URLEncodedString readAlias = IndexNames.encodeName(indexLayoutStrategy.createReadAlias(hibernateSearchIndexName));
        URLEncodedString primaryName = null;
        if (writeAlias == null || readAlias == null) {
            primaryName = IndexNames.encodeName(indexLayoutStrategy.createInitialElasticsearchIndexName(hibernateSearchIndexName));
        } else if (writeAlias.equals(readAlias)) {
            throw log.sameWriteAndReadAliases(writeAlias);
        }
        URLEncodedString readName = readAlias != null ? readAlias : primaryName;
        URLEncodedString writeName = writeAlias != null ? writeAlias : primaryName;
        IndexNames indexNames = new IndexNames(hibernateSearchIndexName, writeName, writeAlias != null, readName, readAlias != null);
        this.indexNamesRegistry.register(indexNames);
        this.typeNameMapping.register(indexNames, mappedTypeName);
        return indexNames;
    }

    @Override
    public SearchProjectionBackendContext getSearchProjectionBackendContext() {
        this.checkStarted();
        return this.searchProjectionBackendContext;
    }

    ElasticsearchVersion getElasticsearchVersion() {
        this.checkStarted();
        return this.elasticsearchVersion;
    }

    void onStart(BeanResolver beanResolver, MultiTenancyStrategy multiTenancyStrategy, ConfigurationPropertySource propertySource) {
        if (this.clientImplementor == null) {
            this.clientImplementor = ((ElasticsearchClientFactory)this.clientFactoryHolder.get()).create(beanResolver, propertySource, this.threads.getThreadProvider(), this.threads.getPrefix(), this.threads.getWorkExecutor(), this.defaultGsonProvider, this.configuredVersionOnBackendCreationOptional);
            this.clientFactoryHolder.close();
            this.elasticsearchVersion = this.initVersion(propertySource);
            ElasticsearchProtocolDialect protocolDialect = this.dialectFactory.createProtocolDialect(this.elasticsearchVersion);
            this.gsonProvider = GsonProvider.create(GsonBuilder::new, this.logPrettyPrinting);
            this.indexMetadataSyntax = protocolDialect.createIndexMetadataSyntax();
            this.searchSyntax = protocolDialect.createSearchSyntax();
            this.workFactory = protocolDialect.createWorkFactory(this.gsonProvider, (Boolean)QUERY_SHARD_FAILURE_IGNORE.get(propertySource));
            this.searchResultExtractorFactory = protocolDialect.createSearchResultExtractorFactory();
            this.scrollTimeout = (Integer)SCROLL_TIMEOUT.get(propertySource);
        }
        this.indexLayoutStrategyHolder = this.createIndexLayoutStrategy(beanResolver, propertySource);
        ProjectionExtractionHelper<String> projectionExtractionHelper = this.typeNameMapping.onStart((IndexLayoutStrategy)this.indexLayoutStrategyHolder.get());
        this.searchProjectionBackendContext = new SearchProjectionBackendContext(projectionExtractionHelper, multiTenancyStrategy.idProjectionExtractionHelper());
    }

    void onStop() {
        try (Closer closer = new Closer();){
            closer.push(BeanHolder::close, this.clientFactoryHolder);
            closer.push(ElasticsearchClientImplementor::close, (Object)this.clientImplementor);
            closer.push(BeanHolder::close, this.indexLayoutStrategyHolder);
        }
    }

    private void checkStarted() {
        if (this.clientImplementor == null) {
            throw new AssertionFailure("Attempt to retrieve Elasticsearch client or related information before the Elasticsearch client was started.");
        }
    }

    private ElasticsearchVersion initVersion(ConfigurationPropertySource propertySource) {
        boolean versionCheckImpossible;
        Optional versionCheckEnabled = (Optional)VERSION_CHECK_ENABLED.get(propertySource);
        Optional configuredVersionOptional = (Optional)VERSION.getAndTransform(propertySource, configuredVersionOnStartOptional -> {
            Optional resultOptional;
            if (configuredVersionOnStartOptional.isPresent()) {
                if (this.configuredVersionOnBackendCreationOptional.isPresent() && !this.configuredVersionOnBackendCreationOptional.get().matches((ElasticsearchVersion)configuredVersionOnStartOptional.get())) {
                    throw log.incompatibleElasticsearchVersionOnStart(this.configuredVersionOnBackendCreationOptional.get(), (ElasticsearchVersion)configuredVersionOnStartOptional.get());
                }
                resultOptional = configuredVersionOnStartOptional;
            } else {
                resultOptional = this.configuredVersionOnBackendCreationOptional;
            }
            if ((resultOptional.isEmpty() || !ElasticsearchDialectFactory.isPreciseEnoughForProtocolDialect((ElasticsearchVersion)resultOptional.get())) && versionCheckEnabled.isPresent() && !((Boolean)versionCheckEnabled.get()).booleanValue()) {
                throw log.impreciseElasticsearchVersionWhenVersionCheckDisabled(VERSION_CHECK_ENABLED.resolveOrRaw(propertySource));
            }
            return resultOptional;
        });
        boolean bl = versionCheckImpossible = configuredVersionOptional.isPresent() && ElasticsearchDialectFactory.isVersionCheckImpossible((ElasticsearchVersion)configuredVersionOptional.get());
        if (versionCheckImpossible && versionCheckEnabled.isPresent() && ((Boolean)versionCheckEnabled.get()).booleanValue()) {
            VERSION_CHECK_ENABLED.getAndMap(propertySource, enabled -> {
                if (enabled.booleanValue()) {
                    throw log.cannotCheckElasticsearchVersion(((ElasticsearchVersion)configuredVersionOptional.get()).distribution());
                }
                return enabled;
            });
        }
        if (versionCheckEnabled.orElse(!versionCheckImpossible).booleanValue()) {
            ElasticsearchVersion configuredVersion;
            ElasticsearchVersion versionFromCluster = this.fetchElasticsearchVersion(propertySource);
            if (configuredVersionOptional.isPresent() && !(configuredVersion = (ElasticsearchVersion)configuredVersionOptional.get()).matches(versionFromCluster)) {
                throw log.unexpectedElasticsearchVersion(configuredVersion, versionFromCluster);
            }
            return versionFromCluster;
        }
        return (ElasticsearchVersion)configuredVersionOptional.get();
    }

    private ElasticsearchVersion fetchElasticsearchVersion(ConfigurationPropertySource propertySource) {
        try {
            ElasticsearchVersion version = ElasticsearchClientUtils.tryGetElasticsearchVersion(this.clientImplementor);
            if (version == null) {
                throw log.unableToFetchElasticsearchVersion(VERSION.resolveOrRaw(propertySource), ElasticsearchDialectFactory.AMAZON_OPENSEARCH_SERVERLESS);
            }
            return version;
        }
        catch (RuntimeException e) {
            throw log.failedToDetectElasticsearchVersion(e.getMessage(), e);
        }
    }

    private BeanHolder<? extends IndexLayoutStrategy> createIndexLayoutStrategy(BeanResolver beanResolver, ConfigurationPropertySource propertySource) {
        return (BeanHolder)LAYOUT_STRATEGY.getAndTransform(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));
    }
}

